import React, { Component } from 'react';
import { IFrame } from 'amos-framework';
import { Store } from 'amos-tool';
import SysConsts from 'amos-processor/lib/config/consts';
import formatUrl from 'amos-processor/lib/utils/urlFormat';
import { getOutterURL } from '../../../consts/urlConsts';

const lsTool = Store.lsTool;
/**
 * 管控模型
 *
 * @class MgtCtrlModel
 * @extends {Component}
 */

class XJCtrlModel extends Component {
  render() {
    const userId = lsTool.read(SysConsts.userId);
    const token = lsTool.read(SysConsts.token);
    const region = lsTool.read('CURRENT_REGION');
    const orgCode = JSON.parse(region).orgCode;
    const url = formatUrl(getOutterURL('xunjian'), { orgCode, userId, token });
    return (
      <div className="rule-model">
        <IFrame
          url={url}
          width="100%"
          height="100%"
          display="initial"
          position="relative"
          allowFullScreen
          scrolling="auto"
        />
      </div>
    );
  }
}
XJCtrlModel.propTypes = {

};

export default XJCtrlModel;
