import React, { Component } from 'react';
import PropTypes from 'prop-types';
import RayMediaquery from 'ray-mediaquery';
import { Row, Col } from 'amos-framework';
import classNames from 'classnames';
import Logo from './Logo';
import NavList from './NavList';
import Tips from './Tips';

const layout = {
  logo: { xs: 4, sm: 6, md: 4, lg: 5, xl: 4 },
  navs: { xs: 14, sm: 10, md: 10, lg: 10, xl: 10 },
  tip: { xs: 6, sm: 8, md: 10, lg: 9, xl: 10 }
};

class Header extends Component {

  constructor(props) {
    super(props);
    this.state = {
      min: false
    };
  }

  componentDidMount() {
    RayMediaquery.register('only screen and (min-width: 0) and (max-width: 1210px)', {
      match: () => {
        this.setState({ min: true });
      },
      unmatch: () => {
        this.setState({ min: false });
      }
    });
  }

  render() {
    const { min } = this.state;
    const { onlyNav, logoIcon, logoText, minIcon, onLogoClick, menus, onMenuItemClick, isAbsolute, address } = this.props;
    const cls = classNames({
      'common-header': true,
      'header-absolute': isAbsolute
    });

    if (onlyNav){
      return (
        <div className={cls}>
          <NavList min={min} menus={menus} onMenuItemClick={onMenuItemClick} />
        </div>
      );
    }
    return (
      <div className={cls}>
        <Row className="header-row">
          <Col {...layout.logo}>
            <Logo icon={logoIcon} text={logoText} onClick={onLogoClick} minIcon={minIcon} min={min} />
          </Col>
          <Col {...layout.navs}>
            <NavList min={min} menus={menus} onMenuItemClick={onMenuItemClick} />
          </Col>
          <Col {...layout.tip}>
            <Tips min={min} address={address} />
          </Col>
        </Row>
      </div>
    );
  }
}

Header.propTypes = {
  onlyNav: PropTypes.bool,
  logoIcon: PropTypes.string,
  logoText: PropTypes.string,
  minIcon: PropTypes.string,
  onLogoClick: PropTypes.func,
  menus: PropTypes.array,
  onMenuItemClick: PropTypes.func,
  isAbsolute: PropTypes.bool,
  address: PropTypes.string
};

export default Header;
