import React from 'react';
import PropTypes from 'prop-types';

const CardItem = props => {
  const { image, name, description, url, permissionCode, onClick } = props;
  return (
    <div className="console-card-item" onClick={() => onClick(url, permissionCode)}>
      <div className="item-pic">
        <img src={image} alt="" />
      </div>
      <div className="item-title">
        <p className="item-title-name">{name}</p>
        <p className="item-title-name">{description}</p>
      </div>
    </div>
  );
};

CardItem.propTypes = {
  image: PropTypes.string,
  name: PropTypes.string,
  description: PropTypes.string,
  url: PropTypes.string,
  permissionCode: PropTypes.string,
  onClick: PropTypes.func
};

export default CardItem;
