import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Store } from 'amos-tool';
import { getBizMenusAction, getPermissionsMenus } from '../../services/securityService';
import Header from '../common/header';
import BusinessStorage from './../bizview';
import PointView from './../bizview/point/PointView';

const lsTool = Store.lsTool;
/**
 * 业务视图
 *
 * @class RootBizView
 * @extends {Component}
 */
class RootBizView extends Component {

  constructor(props) {
    super(props);
    this.state = {
      menus: [],
      parentMenuKey: 'bizview'
    };
  }

  componentDidMount() {
    this.initMenus();
  }

  initMenus = () => {
    const { parentMenuKey } = this.state;
    let role = lsTool.read('selectedRole');
    getPermissionsMenus(role).then(d => {
      this.setState({
        menus: d
      });
    });
    // getBizMenusAction(parentMenuKey).then(d => {
    //   this.setState({
    //     menus: d
    //   });
    // });
  }

  onMenuItemClick() {
    window.localStorage.removeItem('cityLine');
  }

  render() {
    const { menus } = this.state;
    const { children } = this.props;
    return (
      <div className="biz-view-port">
        <BusinessStorage />
        <Header onlyNav menus={menus} onMenuItemClick={this.onMenuItemClick} />
        <div className="content-body">{children || <PointView />}</div>
      </div>
    );
  }
}

RootBizView.propTypes = {
  children: PropTypes.node
};

export default RootBizView;
