import React, { Component } from 'react';
import { Form, AmosAlert, Input, Select } from 'amos-framework';
import { tileViewTypeAction, tileViewListAction, bindTileViewAction } from '../../services/3dService'

const FormItem = Form.Item;
const TextArea = Input.TextArea;
const Option = Select.Option;

/**
 * 坐标绑定弹出框
 *
 * @class BindTileViewModel
 * @extends {Component}
 */
class BindTileViewModel extends Component {
  constructor(props) {
    super(props);
    this.state = {
      searchParam: [],
      form: {
        id: undefined,
        name: '',
        type: '',
        tilePosition: '',
        tileTypeList: [],//类型列表
        sourceList: []//数据
      },
      rules: {
        id: [{ required: true, message: '请选择资源' }],
        type: [{ required: true, message: '请选择资源类型' }],
        tilePosition: [{ required: true, message: '坐标不能为空' }]
      }
    };
  }

  componentWillMount = () => {
    const { tilePosition } = this.props;
    tileViewTypeAction().then(d => {
      this.setState({ tileTypeList: d });
    });
    if (tilePosition != '') {
      let form = {};
      form.tilePosition = tilePosition;
      this.setState({ form });
    }
  };

  onInputChange = (key, value) => {
    const { form } = this.state;
    form[key] = value;
    this.setState({ form });
  };

  onSelectChange = (key, value,item) => {
    const { form } = this.state;
    form[key] = value;
    if (key === 'id') {
      form.name = item.name;
    }
    if (key === 'type') {
        tileViewListAction(value).then(d => {
        this.setState({ sourceList: d });
      });
    }
    this.setState({ form });
  };

  handleSubmit = e => {
    this.form.validate((valid, dataValues) => {
      if (valid) {
        let { form } = this.state;
        this.bindTileViewMethodSave(form);
      } else {
        return false;
      }
    });
  };

  bindTileViewMethodSave = data => {
    console.log(data)
    bindTileViewAction(data).then(
      data => {
        AmosAlert.success('提示', '操作成功');
      },
      err => {
        AmosAlert.error('提示', err);
      }
    );
  };

  render() {
    const { form, rules, tileTypeList, sourceList } = this.state;
    const formItemLayout = {
      labelCol: {
        xs: { span: 24 },
        sm: { span: 7 },
        className: 'colspanlab'
      },
      wrapperCol: {
        xs: { span: 24 },
        sm: { span: 14 },
        className: 'colspan'
      }
    };

    return (
      <div>
        <Form model={form} rules={rules} ref={component => this.form = component}>
          <FormItem label={<span>坐标</span>} field="tilePosition" {...formItemLayout}>
            <Input className='risk_factor_input' value={form.tilePosition} disabled onChange={e => this.onInputChange('tilePosition', e.target.value)} />
          </FormItem>
          <FormItem label={<span>资源类型</span>} field="type" {...formItemLayout}>
            <Select
                className="risk_factor_input"
                data={tileTypeList || []}
                renderOption={item => <Option value={item.type}>{item.name}</Option>}
                value={form.type}
                onChange={(value,item)=> this.onSelectChange('type', value,item)}/>
          </FormItem>
          <FormItem label={<span>资源名称</span>} field="id" {...formItemLayout}>
            <Select
                className="risk_factor_input"
                data={sourceList || []}
                renderOption={item => <Option value={item.id}>{item.code == ''? item.name:item.name + '-' + item.code}</Option>}
                value={parseInt(form.id)}
                onChange={(value,item)=> this.onSelectChange('id', value,item)}
                />
          </FormItem>
        </Form>
      </div>
    );
  }
}

export default BindTileViewModel;
