import React, { Component } from 'react';
import moment from 'moment';
import PropTypes from 'prop-types';
import { SingleQueryEnum } from 'amos-processor/lib/config/queryEnum';
import { Select } from 'amos-framework';
import { DatePicker } from 'amos-antd';
import {
  msgCategoryListAction
} from 'SERVICES/3dService';

const Option = Select.Option;

const typeList = [
  { id: '01', name: '未读' },
  { id: '02', name: '已读' }
];
const MsgTypeEnum = [{
  id: '1',
  name: '安全检查消息'
}, {
  id: '2',
  name: '风险预警消息'
}, {
  id: '3',
  name: '隐患消息'
}, {
  id: '4',
  name: '风险评价消息'
}];

/**
 * 检索-过滤栏
 *
 * @class Filter
 * @extends {Component}
 */
class Filter extends Component {

  static propTypes = {
    onFilterChange: PropTypes.func
  };

  constructor(props) {
    super(props);
    this.state = {
      categoryList: []
    };
  }

  componentDidMount() {
    msgCategoryListAction().then(d => this.setState({ categoryList: d || [] }));
  }

  render() {
    const { onFilterChange } = this.props;
    const { categoryList } = this.state;
    return (
      <div className="datapane-filter-content">
        {/*<Select 规则暂不支持
          className="datapane-filter-item datapane-filter-select"
          data={categoryList}
          renderOption={item => <Option className="datapane-select-option" value={item.id}>{item.name}</Option>}
          defaultOption={<Option className="datapane-select-option">类别</Option>}
          onChange={(e) => onFilterChange('category', e, SingleQueryEnum.EQUAL)}
        />*/}
        <Select
          className="datapane-filter-item datapane-filter-select"
          data={MsgTypeEnum}
          renderOption={item => <Option className="datapane-select-option" value={item.id}>{item.name}</Option>}
          defaultOption={<Option className="datapane-select-option">所有</Option>}
          onChange={(e,item) => onFilterChange('type', item.name, SingleQueryEnum.EQUAL)}
        />
        <DatePicker
          className="datapane-filter-item datapane-filter-date"
          placeholder="时间"
          format="YYYY/MM/DD"
          onChange={(e) => onFilterChange('time', moment(e).format('YYYY-MM-DD'), SingleQueryEnum.EQUAL)}
        />
      </div>
    );
  }
}

export default Filter;
