import React from 'react';
import { Connect } from 'amos-framework';
import { operateTypes } from './../../consts';
import { update3DViewData } from './../../dataProcessor';
import { bizControlsTypes } from './../../conf';
import { search3dAction, queryRiskLevelEumListAction } from './../../../../services/bizService';
import DataPaneBasic from './../common/DataPaneBasic';
import DataPaneContent from './../common/DataPaneContent';
import Filter from './Filter';
import PaneItem from './../common/PaneItem';
import SearchWelCome from './SearchWelCome';
import ListPaginate from './../common/ListPaginate';


const eventConnect = Connect.eventConnect;
/**
 * 检索
 * @class Search
 * @extends {DataPaneBasic}
 */
@eventConnect
class Search extends DataPaneBasic {
  constructor(props) {
    super(props);
    this.state = {
      searchName: 'type',
      data: [],
      filter: [],
      page: 0,
      pageSize: 10,
      isStart: true,
      riskSourceLevel: []
    };
  }

  componentDidMount(){
    this.onSearch(0);
    this.getRiskLevelEumData();
  }

  getRiskLevelEumData = () => {
    queryRiskLevelEumListAction().then(data => {
      this.setState({ riskSourceLevel: data });
    });
  }
  /**
   * 点击检索结果中的一个
   */
  onClick = (item) => {
    // 更新视图数据
    let views = new Array();
    views.push(item);
    let args = {
      target: views,
      operateType: operateTypes.POINT_SEARCH
    };
    update3DViewData(args);
  }

  onSearch = (page) => {
    const { filter, pageSize, isStart } = this.state;
    if (isStart) {
      this.setState({ isStart: false });
    }
    let type = '';
    ( filter || [] ).forEach(item => {
      if (item.name === 'type') {
        type = item.value;
      }
    });
    let newFilter = filter.filter(item => item.name !== 'type');
    let searchParam = [];
    if (type === 'danger') {
      let temp = newFilter.filter(item => item.name === 'dangerLevel' || item.name === 'name');
      searchParam = [...temp,{ name: 'isDanger',type: 'EQUAL',value: true }];
    } else if (type === 'riskSource') {
      searchParam = newFilter.filter(item => item.name === 'riskLevel' || item.name === 'name');
    } else if (type === 'equipment') {
      let temp = newFilter.filter(item => item.name === 'equipType' || item.name === 'name');
      searchParam = temp.map(e=>{
        if (e.name === 'equipType') {
          return { name: 'type',value: e.value,type: 'EQUAL' };
        }
        return e;
      });
    }

    searchParam.forEach(e=>{
      if (e.name === 'name') {
        e.type = 'LIKE';
      }
    });

    type && search3dAction(searchParam, type, page || 0, pageSize).then(d => {//待修改为全部查询
      // 填充列表数据
      this.listRef.setData(d, this);
    });
  }

  getLevelName =(data)=> {
    const { riskSourceLevel } = this.state;
    return riskSourceLevel.length > 0 ? (riskSourceLevel.find(e=>e.id === data.riskLevel ) || {}).level : '';
  }

  renderItem = (item) => {
    if ('riskSource' === item.markType) {
      return [
        { name: '编号', value: 'code' },
        { name: '名称', value: 'name' },
        { name: '等级', value: 'riskLevel', render: this.getLevelName }
      ];
    } else if ('danger' === item.markType) {
      return [
        { name: '编号', value: 'code' },
        { name: '名称', value: 'name' },
        { name: '状态', value: 'checkStatus' },
        { name: '责任人', value: 'username' }
      ];
    } else if ('equipment' === item.markType) {
      return [
        { name: '编号', value: 'code' },
        { name: '名称', value: 'name' },
        { name: '类别', value: 'type' }
      ];
    } else if ('majorHazard' === item.markType) {
      return [
        { name: '编号', value: 'code' },
        { name: '名称', value: 'name' },
        { name: '等级', value: 'riskLevel', render: this.getLevelName }
      ];
    }
  }

  render() {
    const { searchName, data, pageSize, isStart, filter } = this.state;
    let type = '';
    ( filter || [] ).forEach((item, i) => {
      if (item.name === 'type') {
        type = item.value;
      }
    });
    return (
      <DataPaneContent
        onFilterChange={this.onFilterChange}
        filter={Filter}
        type={type}
        dataList={bizControlsTypes}
        searchType={'selectAndInput'}
        searchName={searchName}
      >
        {
          !isStart ?
            <ListPaginate
              ref={node => this.listRef = node}
              data={data}
              pageSize={pageSize}
              onChangePage={this.onSearch}
              renderItem={e => <PaneItem renderItem={this.renderItem} key={e.id} data={e} onClick={this.onClick} />}
            />
            : <SearchWelCome />
        }
      </DataPaneContent>
    );
  }
}

export default Search;
