import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Button } from 'amos-framework';
import SymIcon from './../../../common/icon/SymIcon';
import imgStatic from './../../../../consts/imgStatic';

const opeateIcon = imgStatic.opeateIcon;
/**
 *
 * 步骤区明细
 * @class StepCxtLine
 * @extends {Component}
 */
class StepCxtLine extends Component {
  constructor(props) {
    super(props);

  }

  onButtonClick =(e,content)=>{
    const { onButtonClick } = this.props;
    onButtonClick && onButtonClick(content);
  }

  renderBtn =(message) =>{
    let json = message.content ? JSON.parse(message.content) : {};
    let clickedButton = json.operate.filter(item=>item.state === 'executed' || item.state === 'disable');
    if (clickedButton.length > 0 ) {
      return  <SymIcon icon='zhixingtanchuang-dui' style={{ width: '27px' ,height: '38px' }} />;
    } else {
      return (json.operate || []).map(btn =>{
        btn.batchNo = message.batchNo;
        btn.contingencyPlanId = message.id;
        btn.stepCode = json.stepCode;
        return <Button
          className="operate-button-button"
          transparent
          key={btn.code}
          style={{ backgroundImage: 'url(' + opeateIcon[btn.icon + '-chang'] + ')' }}
          onClick={(e)=>this.onButtonClick(e,btn)}
        >{btn.title}</Button>;
      });
    }
  }

  render() {
    const { message = {} } = this.props;
    let url = opeateIcon[message.icon];
    return (
      <div className='step-cxt-line-root'>
        <div className='step-cxt-line-left'>
          <img src={url} style={{ width: '30px' ,height: '30px' }} alt='' onError={e => { e.target.onerror = null; e.target.style = 'display:none';}} />
          <span className='step-cxt-line-content' >{message.category}</span>
        </div>
        <div className='step-cxt-line-right' >{this.renderBtn(message)}</div>
      </div>
    );
  }
}

StepCxtLine.propTypes = {
  onButtonClick: PropTypes.func,
  message: PropTypes.object,
  openStepCxt: PropTypes.func
};

export default StepCxtLine;
