import React, { Component } from 'react';
import PropTypes from 'prop-types';
// import fireResourceData from './fireResource.json';
import { Connect, Icon, Popover } from 'amos-framework';
import { eventTopics } from './../../../consts';
import SpeedCurve from './SpeedCurve';

const eventConnect = Connect.eventConnect;

@eventConnect
class MonitorView extends Component {
  constructor(props) {
    super(props);
    this.state = {
      data: {},
      waters: [],
      SpeedCurveOpen: true,
      timeCount: 0,
      display: 'none',
      fireResourceData: {
        waterSupply: "35 分"
      },
      monitorData: {
        A_ATI7640_value: '0',
        A_RXI7636_value: '0',
        A_RZI7634_value: '0',
        A_RSPEED_value: '0'
      }
    };
    // this.timer = null;
  }

  componentDidMount() {
    console.log('MonitorView~~~~~~~');
    this.props.subscribe(eventTopics.monitor_view, (topic, data) => {
      if (topic === eventTopics.monitor_view) {
        console.log(eventTopics.monitor_view);
        let { display } = this.state;
        if (display === 'none') {
          this.setState({ display: '' });
        }
        this.setState({ SpeedCurveOpen: true });
      }
    });
  }

  componentWillReceiveProps(nextProps) {
  }

  getSpeedCurveCharts = () => {
    const layoutStyle = {
      height: '200px',
      width: '300px',
      display: this.state.display
    };
    return (
      <div className='speed-curve-chart' style={layoutStyle} >
        <SpeedCurve changeText={this.changeText} />
      </div>
    );
  }

  // prepareChangeTimeText = (planStart) => {
  //   clearInterval(this.timer);
  //   this.timer = setInterval(() => {
  //     this.changeTimeText();
  //   }, 1000);
  // }

  // changeTimeText = () => {
  //   let { timeCount } = this.state;
  //   timeCount += 1;
  //   let formatTime = this.formatTime(timeCount);
  //   let targetEle = document.getElementById('time-text');
  //   targetEle && (targetEle.innerHTML = formatTime);
  //   this.setState({ timeCount });
  // };

  // formatTime = timeCount => {
  //   let secord = parseInt(timeCount); // 秒
  //   let minute = 0; // 分
  //   let hour = 0; // 小时

  //   if (secord >= 59) {
  //     minute = parseInt(secord / 60);
  //     secord = parseInt(secord % 60);
  //     if (minute >= 59) {
  //       hour = parseInt(minute / 60);
  //       minute = parseInt(minute % 60);
  //     }
  //   }
  //   let result = '' + parseInt(hour) + '小时' + parseInt(minute) + '分' + parseInt(secord) + '秒';
  //   return result;
  // };

  changeText = (text) => {
    this.setState({
      monitorData: text
    });
  }

  onClick = (...a) => {
    console.log(...a);
    let { SpeedCurveOpen } = this.state;
    this.setState({ SpeedCurveOpen: !SpeedCurveOpen });
  }

  render() {
    let { display, monitorData, SpeedCurveOpen } = this.state;
    return (
      <div className="precontrol-monitor-view" style={{ display }} >
        <Popover
          content={() => {}}
          direction="right"
          triggerMode="click"
          contentWrapClassName="precontrol-popover-content"
          open={false}
        >
          <div className="monitor-view water-supply" >
            <div className="text-icon" />
            <span>轴承温度</span>
            <span>{monitorData.A_ATI7640_value} ℃</span>
            <Icon icon="right" color="#fca200" />
          </div>
        </Popover>
        <Popover
          content={() => {}}
          direction="right"
          triggerMode="click"
          contentWrapClassName="precontrol-popover-content"
          open={false}
        >
          <div className="monitor-view water-supply" >
            <div className="text-icon" />
            <span>后轴震动</span>
            <span>{monitorData.A_RXI7636_value} um</span>
            <Icon icon="right" color="#fca200" />
          </div>
        </Popover>
        <Popover
          content={() => {}}
          direction="right"
          triggerMode="click"
          contentWrapClassName="precontrol-popover-content"
          open={false}
        >
          <div className="monitor-view water-supply" >
            <div className="text-icon" />
            <span>轴位移</span>
            <span>{monitorData.A_RZI7634_value} mm</span>
            <Icon icon="right" color="#fca200" />
          </div>
        </Popover>
        <Popover
          content={this.getSpeedCurveCharts()}
          direction="right"
          triggerMode="click"
          contentWrapClassName="precontrol-popover-content"
          open={SpeedCurveOpen}
          onToggle={(...e) => this.onClick(...e)}
        >
          <div className="monitor-view water-supply" >
            <div className="text-icon" />
            <span>压缩机组转速</span>
            <span>{monitorData.A_RSPEED_value} rpm</span>
            <Icon icon="right" color="#fca200" />
          </div>
        </Popover>
      </div>
    );
  }
}

MonitorView.propTypes = {
  planStart: PropTypes.bool
  // fireResourceData: PropTypes.object
};

export default MonitorView;
