import React, { Component } from 'react';
import AmosEcharts from 'amos-viz/lib/echarts';
import moment from 'moment';
import { Connect } from 'amos-framework';
import PropTypes from 'amos-react-router/lib/PropTypes';
import indexValue from './indexValue';
import { eventTopics } from './../../../consts';

const eventConnect = Connect.eventConnect;

@eventConnect
class SpeedCurve extends Component {
  constructor(props) {
    super(props);
    this.timer = null;
    this.state = {
      speedData: [],
      targetSpeedData: [],
      A_ATI7640Data: [],
      A_RXI7636Data: [],
      A_RZI7634Data: [],
      index: 0,
      yAxisLabelData: [],
      maxNumber: 0,
      minNumber: 0,
      showContent: false
    };
  }

  componentDidMount() {
    console.log('SpeedCurve~~~~');
    this._bindRulePubSubEvents();
    this.getSecondsLabel();
  }

  componentWillUnmount(){
    clearInterval(this.timer);
  }

  getTime = () => {
    clearInterval(this.timer);
    this.timer = setInterval(() => {
      this.getRealTimeData();
    }, 2000);
  }

  getSecondsLabel = () => {
    let interval = 1;
    let array =  [];
    let now = new Date(moment());
    while (array.length <= 30) {
      let timeFormat = 'HH:mm:ss';
      // let m = moment().format('HH:mm:ss');
      let oldTime = new Date(now.getTime() - 2000);
      now = oldTime;
      let timeStr = moment(oldTime).format(timeFormat);
      array.push(timeStr);
      // array.push(m);
      interval = interval + 1;
    }
    this.setState({ yAxisLabelData: array.reverse() });
  }

  getRealTimeData = () => {
    let text = {};
    let { index, speedData, A_ATI7640Data, A_RXI7636Data, A_RZI7634Data, targetSpeedData, maxNumber, minNumber } = this.state;
    index += 1;
    if (index === speedData.length - 1) {
      index = 0;
    }
    targetSpeedData =  [...speedData];
    targetSpeedData = targetSpeedData.slice(0+index, 30+index);
    text.A_ATI7640_value = A_ATI7640Data[30+index-1];
    text.A_RXI7636_value = A_RXI7636Data[30+index-1];
    text.A_RZI7634_value = A_RZI7634Data[30+index-1];
    text.A_RSPEED_value = speedData[30+index-1];
    maxNumber = Math.round(Math.max(...targetSpeedData)) + 1;
    minNumber = Math.round(Math.min(...targetSpeedData));
    this.getSecondsLabel();
    this.setState({ index, targetSpeedData, maxNumber, minNumber });
    this.props.changeText(text);
  }

  getOptions = () => {
    let { targetSpeedData, yAxisLabelData, maxNumber, minNumber } = this.state;
    return {
      tooltip: {
        trigger: 'axis'
      },
      grid: {
        left: '17%'
      },
      xAxis: {
        type: 'category',
        axisLabel: {
          // interval: 2,
          // minInterval: 2,
          rotate: 45,
          color: 'white'
        },
        splitLine: {
          lineStyle: {
            color: 'white'
          }
        },
        axisLine: {
          lineStyle: {
            color: 'white'
          }
        },
        data: yAxisLabelData
      },
      yAxis: {
        axisLabel: {
          color: 'white'
        },
        axisLine: {
          lineStyle: {
            color: 'white'
          }
        },
        nameTextStyle: {
          color: 'white'
        },
        type: 'value',
        min: minNumber,
        max: maxNumber,
        name: '转速'
      },
      series: [
        {
          name: '转速',
          type: 'line',
          data: targetSpeedData
        }]
    };
  }

  _bindRulePubSubEvents = () => {
    this.props.subscribe(eventTopics.monitor_speed_view, (topic, data) => {
      let { stepCode } = data.data;
      if (stepCode === '0') {
        this.setState({
          speedData: indexValue.step1.A_RSPEED,
          A_ATI7640Data: indexValue.step1.A_ATI7640,
          A_RXI7636Data: indexValue.step1.A_RXI7636,
          A_RZI7634Data: indexValue.step1.A_RZI7634
        });
      } else if (stepCode === '1') {
        this.setState({
          speedData: indexValue.step2.A_RSPEED,
          A_ATI7640Data: indexValue.step2.A_ATI7640,
          A_RXI7636Data: indexValue.step2.A_RXI7636,
          A_RZI7634Data: indexValue.step2.A_RZI7634
        });
      } else if (stepCode === '2') {
        this.setState({
          speedData: indexValue.step3.A_RSPEED,
          A_ATI7640Data: indexValue.step3.A_ATI7640,
          A_RXI7636Data: indexValue.step3.A_RXI7636,
          A_RZI7634Data: indexValue.step3.A_RZI7634
        });
      } else if (stepCode === '3') {
        this.setState({
          speedData: indexValue.step4.A_RSPEED,
          A_ATI7640Data: indexValue.step4.A_ATI7640,
          A_RXI7636Data: indexValue.step4.A_RXI7636,
          A_RZI7634Data: indexValue.step4.A_RZI7634
        });
      } else if (stepCode === '4') {
        this.setState({
          speedData: indexValue.step5.A_RSPEED,
          A_ATI7640Data: indexValue.step5.A_ATI7640,
          A_RXI7636Data: indexValue.step5.A_RXI7636,
          A_RZI7634Data: indexValue.step5.A_RZI7634
        });
      }
      this.getTime();
      this.setState({ showContent: true });
    });
  }

  render() {
    let { showContent } = this.state;
    return (
      <div style={{ width: '100%', height: '100%' }}>
        { showContent && <AmosEcharts option={this.getOptions()} /> }
      </div>
    );
  }
}

SpeedCurve.propTypes = {
  subscribe: PropTypes.func,
  changeText: PropTypes.func
};

export default SpeedCurve;
