import React, { Component } from 'react';
import PropTypes from 'prop-types';
import moment from 'moment';
// import fireResourceData from './fireResource.json';
import { Connect, Row, Col } from 'amos-framework';
import { eventTopics } from './../../../consts';

import { queryContingencyWater } from './../../../../../services/3dService';

const eventConnect = Connect.eventConnect;

@eventConnect
class MonitorView extends Component {
  constructor(props) {
    super(props);
    this.state = {
      data: {},
      waters: [],
      timeCount: 0,
      display: 'none',
      fireResourceData: {
        "firePool": "0 m³",
        "waterLevelGauge": "0 m",
        "waterSupply": "0 分",
        "foamCapacity": "0 m³"
      }
    };
    // this.timer = null;
  }

  componentDidMount() {
    this.props.subscribe(eventTopics.monitor_view, (topic, data) => {
      if (topic === eventTopics.monitor_view) {
        // let { planStart } = this.props;
        // this.prepareChangeTimeText(planStart);
        let { display } = this.state;
        if (display === 'none') {
          this.setState({ display: '' });
        }
      }
    });
    // this.initMonitor();
  }

  componentWillReceiveProps(nextProps) {
    if (!nextProps.fireResourceData) {
      return;
    }
    let { waters } = this.state;
    waters = waters.map(water => {
      if (water.CODE === nextProps.fireResourceData.pointCode) {
        water.level = nextProps.fireResourceData.state || 0;
        water.volume = (water.area || 0) * (nextProps.fireResourceData.state || 0);
      }
      return water;
    });
    this.setState({ waters });
  }

  componentWillUnmount() {
    // clearTimeout(this.timer);
  }

  initMonitor = () => {
    queryContingencyWater().then(
      data => {
        let water = data.map(item => {
          item.level =  8;
          item.volume =  8;
          return item;
        });
        this.setState({ waters: water });
      }
    );
  }

  mapContent = (waters) => {
    let content = new Array();
    let item = Array();
    let obj = Object();
    for (let i = 0; i < waters.length; i++) {
      if ( i % 2 === 0) {
        if (item.length === 2) {
          obj = new Object();
          obj.item = item;
          content.push(obj);
        }
        item = new Array();
        item.push(waters[i]);
      } else {
        item.push(waters[i]);
      }
    }
    if (item.length > 0) {
      obj = new Object();
      obj.item = item;
      content.push(obj);
    }

    return content;
  }

  render() {
    let { display, fireResourceData, waters } = this.state;
    let waterData = this.mapContent(waters);
    return (
      <div className="precontrol-water-view" style={{ display }} >
        {
          this.mapContent(waters).map((water, index) => {
            let waterRow = 'waterRow';
            if ((index + 1) !== waterData.length) {
              waterRow += ' waterRowBorder';
            }
            return (
              <Row type="flex" className={waterRow} justify="center">
                {
                  water.item.map((w, index) => {
                    let borderRight = 'waterRowPadding';
                    if (index === 0) {
                      borderRight += ' waterCenterBorder';
                    }
                    if (index === 1) {
                      borderRight += ' waterRowPadding';
                    }
                    return (
                      <Col span={12} className={borderRight}>
                        <Row type="flex" className="waterName" justify="center">
                          <Col span={24}>{w.name}</Col>
                        </Row>
                        <Row type="flex" className="waterValue" justify="center">
                          <Col span={12}>{w.level}</Col>
                          <Col span={12}>{w.volume}</Col>
                        </Row>
                        <Row type="flex"  className="waterClass" justify="center">
                          <Col span={12}><div className="text-icon" /><span>液位</span></Col>
                          <Col span={12}><div className="text-icon-rongliang" /><span>容量</span></Col>
                        </Row>
                      </Col>
                    );
                  })
                }
              </Row>
            );
          })
        }

      </div>
    );
    // return (
    //   <div className="precontrol-monitor-view" style={{ display }} >
    //     <div className="monitor-view fire-pool">
    //       <div className="text-icon" />
    //       <span>水池容量</span>
    //       <span>{fireResourceData.firePool}</span>
    //     </div>
    //     <div className="monitor-view water-gauge">
    //       <div className="text-icon" />
    //       <span>当前液位</span>
    //       <span>{fireResourceData.waterLevelGauge}</span>
    //     </div>
    //     <div className="monitor-view water-supply">
    //       <div className="text-icon" />
    //       <span>持续供水</span>
    //       <span>{fireResourceData.waterSupply}</span>
    //     </div>
    //     <div className="monitor-view foam-capacity">
    //       <div className="text-icon" />
    //       <span>泡沫容量</span>
    //       <span>{fireResourceData.foamCapacity}</span>
    //     </div>
    //   </div>
    // );
  }
}

MonitorView.propTypes = {
  planStart: PropTypes.bool,
  fireResourceData: PropTypes.object
};

export default MonitorView;
