import React,{ Component } from 'react';
import PropTypes from 'prop-types';
import { Row, Col, Paragraph, IFrame, Modal } from 'amos-framework';
import imgStatic from './../../../../consts/imgStatic';
import Picture from './Picture';
import { videoUrl } from './../../../../consts/urlConsts';

const pointIcon = imgStatic.planDetail;

class AssistCard extends Component{
  constructor(props) {
    super(props);
    this.state = {
      display: true
    };
  }

  componentWillMount() {
    this.setState({ data: this.props.data });
  }

  componentDidMount() {
    if (document.getElementById('iframe-v')) {
      let height =  document.getElementById('iframe-v').offsetHeight;
      document.getElementById('iframe-v').style.height = height;
    }
  }

  componentWillReceiveProps(nextProps) {
    this.setState({ data: nextProps.data });
  }

  onChange = (e) => {
    const { display } = this.state;
    this.setState({ display: !display });
  }

  getListTables = () => {

  }

  onClick = () => {
    this.setState({ modal: true });
  }

  getContext = (videoUrl) => {
    return (<IFrame
      url={videoUrl}
      width="100%"
      height="100%"
      display="initial"
      position="relative"
      allowFullScreen
      scrolling="auto"
      frameborder="0"
    />);
  }

  cancel = () => {
    this.setState({ modal: false });
  }

  render() {
    const { display, data, modal } = this.state;
    let titleStyle = `detailCardTitle-${data.icon}`;
    let showVideo = data.table === 'video' ? true : false;
    return (
      <div className="detailCard">
        <div className={titleStyle}>
          <Row className="cardRow">
            <Col span={24} className="cardCol"><img src={pointIcon[data.icon]} className="precontrol-assist-card-img" /><span  title={data.title || ''} className="cardTitleName">{data.title || ''}</span></Col>
          </Row>
        </div>
        { !showVideo ? (<div className={display ? "detailAssistCardContxt" : "detailAssistCardContxt-notDisplay"}>
          { data.image !== '无' && <Picture className="precontro-assist-card-content" markerData={eval(data.image)} />}
          { data.table !== '无' && this.getListTables(data.table)}
          { data.content !== '无' && <Paragraph className="precontro-assist-card-content" html={data.content} />}
        </div>) :
        <div>
          <div style={{ width: '100%', height: '183px', position: 'absolute', zIndex: '1000' }} onClick={this.onClick} />
          <IFrame
            id='iframe-v'
            url={videoUrl}
            width="100%"
            height="100%"
            display="initial"
            position="relative"
            allowFullScreen
            scrolling="auto"
            frameborder="0"
            onClick={this.onClick}
          />
        </div>
      }
        <Modal
          className='assist-card-video-modal'
          visible={modal}
          destroyContent
          width='85%'
          height='90%'
          style={{ padding: '0px' }}
          content={this.getContext(videoUrl)}
          onCancel={() => this.cancel()}
          noDefaultFooter
          noDefaultHeader
        />
      </div>
    );
  }
}

AssistCard.propTypes = {
  data: PropTypes.object
};

export default AssistCard;
