/*
 * Decompiled with CFR 0.152.
 */
package com.hikvision.swdf.core.executor;

import com.ivms6.core.util.StringUtils;
import com.ivms6.core.util.cm.ConfigManager;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadExecutorService {
    private static Logger log = LoggerFactory.getLogger(ThreadExecutorService.class);
    protected static ExecutorService executor;

    private static void initPool() {
        String configThreadCount = ConfigManager.getConfiguration((String)"thread-config", (String)"service.thread.count");
        String configThreadMin = ConfigManager.getConfiguration((String)"thread-config", (String)"service.thread.minimum");
        String timeKeepAlive = ConfigManager.getConfiguration((String)"thread-config", (String)"service.thread.keep-alive");
        int poolMax = ThreadExecutorService.toInt(configThreadCount, 20, 200, 5);
        int poolMin = ThreadExecutorService.toInt(configThreadMin, poolMax, poolMax, 0);
        int keepAlive = 0;
        if (poolMax != poolMin) {
            keepAlive = ThreadExecutorService.toInt(timeKeepAlive, 300, 86400, 30);
        }
        log.info("init excutor. pool max_size:{} core_size:{} idle-keep-alive:{}", new Object[]{poolMax, poolMin, keepAlive});
        executor = new ThreadPoolExecutor(poolMin, poolMax, keepAlive, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    }

    public static void execute(Runnable cmd) {
        if (cmd == null) {
            log.info("task is null.");
            return;
        }
        log.info("start execute task:" + cmd.getClass().getName());
        try {
            executor.execute(cmd);
        }
        catch (RejectedExecutionException e) {
            log.error("execute task error.", (Throwable)e);
        }
        catch (Exception e) {
            log.error("execute task error.", (Throwable)e);
        }
    }

    public static <T> Future<T> submit(Callable<T> call) {
        if (call == null) {
            log.info("task is null");
            return null;
        }
        log.info("submit execute task:" + call.getClass().getName());
        Future<T> result = null;
        try {
            result = executor.submit(call);
        }
        catch (RejectedExecutionException e) {
            log.error("submit task error.", (Throwable)e);
        }
        catch (Exception e) {
            log.error("submit task error.", (Throwable)e);
        }
        return result;
    }

    public static void shutdown() {
        try {
            executor.shutdown();
            log.info("renew excutor.");
            ThreadExecutorService.initPool();
        }
        catch (Exception e) {
            log.error("shutdown execut service error.", (Throwable)e);
        }
    }

    public static boolean isShutdown() {
        return executor.isShutdown();
    }

    public static boolean isTerminated() {
        return executor.isTerminated();
    }

    private static int toInt(String str, int defaultValue, int max, int min) {
        if (str == null) {
            return defaultValue;
        }
        if (StringUtils.isEmpty((String)(str = str.trim()))) {
            return defaultValue;
        }
        try {
            int v = Integer.parseInt(str);
            if (v > max) {
                return max;
            }
            if (v < min) {
                return min;
            }
            return v;
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    static {
        ThreadExecutorService.initPool();
    }
}

