/*
 * Decompiled with CFR 0.152.
 */
package com.hikvision.swdf.core.lock;

import com.hikvision.swdf.core.lock.ILock;
import com.hikvision.swdf.core.lock.ILockBuilder;
import com.hikvision.swdf.core.lock.LockConfigException;
import com.hikvision.swdf.core.lock.LockException;
import com.hikvision.swdf.core.lock.LockStatistics;

public abstract class AbstractLockBuilder
implements ILockBuilder {
    private static final int DEFAULT_EXPIRETIMES = 10;
    private int expireTime = 10;

    public AbstractLockBuilder() {
    }

    public AbstractLockBuilder(int expireTime) {
        this.expireTime = expireTime;
        if (expireTime < 0) {
            throw new LockConfigException("expireTime must gt 0");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ILock lock(String target) throws LockException {
        String result = LockStatistics.startLock(target);
        try {
            ILock iLock = this.lock(target, this.expireTime);
            return iLock;
        }
        finally {
            LockStatistics.endLock(target, result);
        }
    }

    @Override
    public final ILock tryLock(String target) throws LockException {
        return this.tryLock(target, this.expireTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ILock tryLock(String target, long waitTime) throws LockException {
        String result = LockStatistics.startLock(target);
        try {
            ILock iLock = this.tryLock(target, waitTime, this.expireTime);
            return iLock;
        }
        finally {
            LockStatistics.endLock(target, result);
        }
    }
}

