/*
 * Decompiled with CFR 0.152.
 */
package com.hikvision.swdf.core.lock;

import com.hikvision.swdf.core.lock.IExpireTimeDispose;
import com.hikvision.swdf.core.lock.ILock;
import com.hikvision.swdf.core.lock.IThreadLocalLock;
import com.hikvision.swdf.core.lock.LockException;
import com.hikvision.swdf.core.lock.db.DBSourceLock;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpireTimeDispose
implements IExpireTimeDispose,
Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(ExpireTimeDispose.class);
    private final Map<ILock, Long> lockMap = new ConcurrentHashMap<ILock, Long>();
    private final Object object = new Object();
    private volatile long minExpire = 0L;
    private volatile boolean onStart = false;
    private volatile boolean onNowAdd = false;

    public Map<ILock, Long> getLockMap() {
        return this.lockMap;
    }

    public long getMinExpire() {
        return this.minExpire;
    }

    public boolean isOnStart() {
        return this.onStart;
    }

    public boolean isOnNowAdd() {
        return this.onNowAdd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(ILock lock, int expireTime) {
        long expire = System.nanoTime() / 1000000L + (long)(expireTime * 1000);
        this.lockMap.put(lock, expire);
        this.onNowAdd = true;
        if (LOG.isDebugEnabled()) {
            LOG.debug("add target:{},expireTime:{},targetId:{}", new Object[]{lock.getTarget(), expireTime, lock instanceof DBSourceLock ? ((DBSourceLock)lock).getTargetId() : -1L});
            LOG.debug("synchronized object minExpire:{},expire{}", new Object[]{this.minExpire, expire});
        }
        if (this.minExpire < 1L || expire < this.minExpire) {
            this.minExpire = expire;
            Object object = this.object;
            synchronized (object) {
                this.object.notify();
            }
            LOG.debug("notify object");
        }
        if (!this.onStart) {
            this.onStart = true;
            Thread thread = new Thread(this);
            thread.start();
            LOG.debug("thread start");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(ILock lock) {
        Long expire = this.lockMap.get(lock);
        this.lockMap.remove(lock);
        if (LOG.isDebugEnabled()) {
            LOG.debug("remove target:{},targetId:{}", new Object[]{lock.getTarget(), lock instanceof DBSourceLock ? ((DBSourceLock)lock).getTargetId() : -1L});
            LOG.debug("synchronized object minExpire:{},expire{}", new Object[]{this.minExpire, expire});
        }
        if (expire != null && expire == this.minExpire) {
            Object object = this.object;
            synchronized (object) {
                this.object.notify();
            }
            LOG.debug("notify object");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = this.object;
        synchronized (object) {
            while (this.onStart) {
                this.onNowAdd = false;
                long current = System.nanoTime() / 1000000L;
                if (this.minExpire - current > 0L) {
                    try {
                        long times = this.minExpire - current + 10L;
                        LOG.debug("wait time {}ms", (Object)times);
                        this.object.wait(times);
                    }
                    catch (InterruptedException e) {
                        LOG.warn("wait exception", (Throwable)e);
                    }
                }
                current = System.nanoTime() / 1000000L;
                long newMinExpire = 0L;
                Iterator<Map.Entry<ILock, Long>> iterator = this.lockMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<ILock, Long> entry = iterator.next();
                    long expire = entry.getValue();
                    if (expire < current) {
                        try {
                            ILock lock = entry.getKey();
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("remove target:{},targetId:{}", new Object[]{lock.getTarget(), lock instanceof DBSourceLock ? ((DBSourceLock)lock).getTargetId() : -1L});
                                LOG.debug("synchronized object minExpire:{},expire{}", new Object[]{this.minExpire, expire});
                            }
                            if (lock instanceof IThreadLocalLock) {
                                ((IThreadLocalLock)((Object)lock)).unLock(false);
                            } else {
                                lock.unLock();
                            }
                            iterator.remove();
                        }
                        catch (LockException e) {
                            LOG.warn("unLock exception", (Throwable)e);
                        }
                        continue;
                    }
                    if (newMinExpire >= 1L && expire >= newMinExpire) continue;
                    newMinExpire = expire;
                }
                this.minExpire = newMinExpire;
                if (this.onNowAdd || this.minExpire >= 1L || this.lockMap.size() >= 1) continue;
                this.onStart = false;
            }
        }
        LOG.debug("thread stop");
    }
}

