/*
 * Decompiled with CFR 0.152.
 */
package com.hikvision.swdf.core.lock;

import com.hikvision.swdf.core.lock.HasLockedException;
import com.hikvision.swdf.core.lock.ILockStatistics;
import com.hikvision.swdf.core.lock.LockException;
import com.hikvision.swdf.core.lock.UnLockException;
import com.ivms6.core.util.DateFormatUtils;
import com.ivms6.core.util.cm.ConfigManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockStatistics
implements ILockStatistics {
    private static final Logger LOG = LoggerFactory.getLogger(LockStatistics.class);
    private static volatile boolean isStatistics = false;
    private static final Map<String, List<String>> hasLockedStatic;
    private static final Map<String, List<String>> unLockedFailStatic;
    private static final Map<String, List<String>> lockedSuccessStatic;
    private static final Map<String, List<String>> blockingLock;

    public static boolean isStatistics() {
        return isStatistics;
    }

    public static void setStatistics(boolean isStatistics) {
        if (!isStatistics) {
            LockStatistics.clear();
        }
        LockStatistics.isStatistics = isStatistics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String startLock(String target) {
        if (!isStatistics) {
            return null;
        }
        StringBuilder msg = new StringBuilder();
        msg.append("[").append(DateFormatUtils.getDefaultCurrentDate()).append("]");
        String result = msg.toString();
        LOG.debug("target:{},info:{}", (Object)target, (Object)result);
        Map<String, List<String>> map = blockingLock;
        synchronized (map) {
            List<String> list = blockingLock.get(target);
            if (list == null) {
                list = new ArrayList<String>();
                blockingLock.put(target, list);
            }
            list.add(result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void endLock(String target, String result) {
        if (!isStatistics) {
            return;
        }
        Map<String, List<String>> map = blockingLock;
        synchronized (map) {
            blockingLock.get(target).remove(result);
        }
        LOG.debug("target:{},info:{}", (Object)target, (Object)result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parse(LockException exception) {
        if (!isStatistics || exception == null) {
            return;
        }
        if (exception instanceof HasLockedException) {
            String target = exception.getTarget();
            StringBuilder msg = new StringBuilder();
            msg.append("[").append(DateFormatUtils.getDefaultCurrentDate());
            msg.append(":").append(((HasLockedException)exception).getType());
            msg.append(exception.getMessage()).append("]");
            LOG.debug("target:{},info:{}", (Object)target, (Object)msg);
            Map<String, List<String>> map = hasLockedStatic;
            synchronized (map) {
                List<String> list = hasLockedStatic.get(target);
                if (list == null) {
                    list = new ArrayList<String>();
                    hasLockedStatic.put(target, list);
                }
                list.add(msg.toString());
            }
        }
        if (exception instanceof UnLockException) {
            String target = exception.getTarget();
            StringBuilder msg = new StringBuilder();
            msg.append("[").append(DateFormatUtils.getDefaultCurrentDate());
            msg.append(":").append(exception.getMessage()).append("]");
            LOG.debug("target:{},info:{}", (Object)target, (Object)msg);
            Map<String, List<String>> map = unLockedFailStatic;
            synchronized (map) {
                List<String> list = unLockedFailStatic.get(target);
                if (list == null) {
                    list = new ArrayList<String>();
                    unLockedFailStatic.put(target, list);
                }
                list.add(msg.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recordSuccess(String target) {
        if (!isStatistics) {
            return;
        }
        StringBuilder msg = new StringBuilder();
        msg.append("[").append(DateFormatUtils.getDefaultCurrentDate()).append("]");
        LOG.debug("target:{},info:{}", (Object)target, (Object)msg);
        Map<String, List<String>> map = lockedSuccessStatic;
        synchronized (map) {
            List<String> list = lockedSuccessStatic.get(target);
            if (list == null) {
                list = new ArrayList<String>();
                lockedSuccessStatic.put(target, list);
            }
            list.add(msg.toString());
        }
    }

    public static void clear() {
        hasLockedStatic.clear();
        lockedSuccessStatic.clear();
        blockingLock.clear();
        unLockedFailStatic.clear();
        LOG.debug("doClear");
    }

    public static Map<String, List<String>> getHasLockedStatic() {
        return hasLockedStatic;
    }

    public static Map<String, List<String>> getLockedSuccessStatic() {
        return lockedSuccessStatic;
    }

    public static Map<String, List<String>> getBlockingLock() {
        return blockingLock;
    }

    public static Map<String, List<String>> getUnLockedFailStatic() {
        return unLockedFailStatic;
    }

    static {
        try {
            String res = ConfigManager.getConfiguration((String)"jmx-config", (String)"jmx.statistics");
            if (res != null && "true".equals(res.trim())) {
                isStatistics = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        hasLockedStatic = new HashMap<String, List<String>>();
        unLockedFailStatic = new HashMap<String, List<String>>();
        lockedSuccessStatic = new HashMap<String, List<String>>();
        blockingLock = new HashMap<String, List<String>>();
    }
}

