/*
 * Decompiled with CFR 0.152.
 */
package com.hikvision.swdf.core.lock;

import com.hikvision.swdf.core.lock.ISourceThreadLock;
import com.hikvision.swdf.core.lock.LockException;
import com.ivms6.core.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SourceThreadLock
implements ISourceThreadLock {
    public static final String TARGET_NAME_REGEX = "[^/\\\\:<>*?|\"]+";
    private final ConcurrentHashMap<Object, Byte> lockSet = new ConcurrentHashMap();
    private static ThreadLocal<Map<Object, Integer>> lockThreadLocal = new ThreadLocal();

    public Object getTarget(String targetS) throws LockException {
        if (StringUtils.isBlank((String)targetS)) {
            throw new LockException(targetS, "sourceName is blank");
        }
        if (targetS.length() > 128) {
            throw new LockException(targetS, "sourceName length is gt 128");
        }
        if (!targetS.matches(TARGET_NAME_REGEX)) {
            throw new LockException(targetS, "sourceName contain \\/:*?\"<>| and not right filename");
        }
        return targetS.intern();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int lock(String targetS) throws LockException {
        Object target = this.getTarget(targetS);
        int count = 0;
        count = this.countOnThreadLocal(target);
        if (count > 0) {
            this.addToThreadLocal(target, count);
            return count;
        }
        Object object = target;
        synchronized (object) {
            while (this.contains(target)) {
                try {
                    target.wait();
                }
                catch (InterruptedException e) {
                    throw new LockException(targetS, "target wait exception", e);
                }
            }
            this.add(target);
        }
        this.addToThreadLocal(target, 0);
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int tryLock(String targetS) throws LockException {
        Object target = this.getTarget(targetS);
        int count = 0;
        count = this.countOnThreadLocal(target);
        if (count > 0) {
            this.addToThreadLocal(target, count);
            return count;
        }
        Object object = target;
        synchronized (object) {
            if (this.contains(target)) {
                return -1;
            }
            this.add(target);
        }
        this.addToThreadLocal(target, 0);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int tryLock(String targetS, long waitTime) throws LockException {
        Object target = this.getTarget(targetS);
        int count = 0;
        count = this.countOnThreadLocal(target);
        if (count > 0) {
            this.addToThreadLocal(target, count);
            return count;
        }
        Object object = target;
        synchronized (object) {
            if (this.contains(target)) {
                try {
                    target.wait(waitTime);
                }
                catch (InterruptedException e) {
                    throw new LockException(targetS, "target sleep exception", e);
                }
            }
            if (this.contains(target)) {
                return -1;
            }
            this.add(target);
        }
        this.addToThreadLocal(target, 0);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unLock(String targetS) throws LockException {
        Object target;
        Object object = target = this.getTarget(targetS);
        synchronized (object) {
            this.remove(target);
            target.notify();
        }
    }

    public void add(Object target) {
        this.lockSet.put(target, (byte)1);
    }

    public void addToThreadLocal(Object target, int count) {
        Map<Object, Integer> map = lockThreadLocal.get();
        if (map == null) {
            map = new HashMap<Object, Integer>();
            lockThreadLocal.set(map);
        }
        map.put(target, count + 1);
    }

    public int countOnThreadLocal(Object target) {
        Map<Object, Integer> map = lockThreadLocal.get();
        if (map == null) {
            return 0;
        }
        Integer count = map.get(target);
        if (count == null || count < 0) {
            return 0;
        }
        return count;
    }

    public boolean contains(Object target) {
        return this.lockSet.containsKey(target);
    }

    public void remove(Object target) {
        this.removeOnThreadLocal(target);
        this.lockSet.remove(target);
    }

    public void removeOnThreadLocal(Object target) {
        Map<Object, Integer> map = lockThreadLocal.get();
        if (map == null || map.get(target) == null) {
            return;
        }
        Integer count = map.get(target);
        if (count < 1) {
            map.remove(target);
        } else {
            map.put(target, count - 1);
        }
    }
}

