/*
 * Decompiled with CFR 0.152.
 */
package com.hikvision.swdf.core.lock.db;

import com.hikvision.swdf.core.lock.AbstractLockBuilder;
import com.hikvision.swdf.core.lock.HasLockedException;
import com.hikvision.swdf.core.lock.IExpireTimeDispose;
import com.hikvision.swdf.core.lock.ILock;
import com.hikvision.swdf.core.lock.ISourceThreadLock;
import com.hikvision.swdf.core.lock.LockException;
import com.hikvision.swdf.core.lock.NestedLockException;
import com.hikvision.swdf.core.lock.db.DBLockNotifyQueue;
import com.hikvision.swdf.core.lock.db.DBSourceLock;
import com.hikvision.swdf.core.lock.db.IDBLockDispose;
import com.hikvision.swdf.core.lock.db.IDBLockNotifyQueue;

public class DBLockBuilder
extends AbstractLockBuilder {
    private IDBLockDispose dbLockDispose;
    private ISourceThreadLock threadSourceLock;
    private IDBLockNotifyQueue dbLockNotifyQueue;
    private IExpireTimeDispose expireTimeDispose;

    public DBLockBuilder() {
    }

    public DBLockBuilder(int expireTime) {
        super(expireTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ILock lock(String target, int expireTime) throws LockException {
        int count = this.threadSourceLock.lock(target);
        if (count < 0) {
            throw new LockException(target, "db thread lock fails");
        }
        if (count > 0) {
            throw new NestedLockException(target, "db thread lock is not support nested");
        }
        Object dbTarget = DBLockNotifyQueue.toDBTarget(target);
        boolean onTargetAdd = false;
        try {
            long targetId = 0L;
            Object object = dbTarget;
            synchronized (object) {
                while ((targetId = this.dbLockDispose.clearExpireAndSave(target, expireTime * 1000)) < 1L) {
                    if (!onTargetAdd) {
                        this.dbLockNotifyQueue.add(target);
                        onTargetAdd = true;
                    }
                    dbTarget.wait();
                }
            }
            if (onTargetAdd) {
                this.dbLockNotifyQueue.remove(target);
            }
            DBSourceLock lock = new DBSourceLock(targetId, target, this.threadSourceLock, this.dbLockDispose);
            this.expireTimeDispose.add(lock, expireTime);
            return lock;
        }
        catch (Throwable e) {
            try {
                if (onTargetAdd) {
                    this.dbLockNotifyQueue.remove(target);
                }
            }
            finally {
                this.threadSourceLock.unLock(target);
            }
            if (e instanceof Exception) {
                throw new LockException(target, "db process lock exception", (Exception)e);
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            throw new LockException(target, "db process lock exception");
        }
    }

    @Override
    public ILock tryLock(String target, int expireTime) throws LockException {
        int count = this.threadSourceLock.tryLock(target);
        if (count < 0) {
            throw new HasLockedException(1, target, "db thread tryLock has locked");
        }
        if (count > 0) {
            throw new NestedLockException(target, "thread lock is not support nested");
        }
        try {
            long targetId = 0L;
            targetId = this.dbLockDispose.clearExpireAndSave(target, expireTime * 1000);
            if (targetId > 0L) {
                DBSourceLock lock = new DBSourceLock(targetId, target, this.threadSourceLock, this.dbLockDispose);
                this.expireTimeDispose.add(lock, expireTime);
                return lock;
            }
            throw new HasLockedException(2, target, "db process tryLock has locked");
        }
        catch (Throwable e) {
            this.threadSourceLock.unLock(target);
            if (e instanceof HasLockedException) {
                throw (HasLockedException)e;
            }
            if (e instanceof Exception) {
                throw new LockException(target, "db process tryLock exception", (Exception)e);
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            throw new LockException(target, "db process tryLock exception");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ILock tryLock(String target, long waitTime, int expireTime) throws LockException {
        long start = System.nanoTime() / 1000000L;
        int count = this.threadSourceLock.tryLock(target, waitTime);
        if (count < 0) {
            throw new HasLockedException(1, target, "db thread tryLock wait has locked");
        }
        if (count > 0) {
            throw new NestedLockException(target, "thread lock is not support nested");
        }
        Object dbTarget = DBLockNotifyQueue.toDBTarget(target);
        boolean onTargetAdd = false;
        try {
            long targetId = 0L;
            while ((targetId = this.dbLockDispose.clearExpireAndSave(target, expireTime * 1000)) <= 0L) {
                if (!onTargetAdd) {
                    this.dbLockNotifyQueue.add(target);
                    onTargetAdd = true;
                }
                Object object = dbTarget;
                synchronized (object) {
                    long end = System.nanoTime() / 1000000L;
                    long dist = waitTime - (end - start);
                    if (dist <= 0L) {
                        break;
                    }
                    dbTarget.wait(dist > 1000L ? 1000L : dist);
                }
            }
            if (targetId < 1L) {
                throw new HasLockedException(2, target, "db process tryLock wait has locked");
            }
            DBSourceLock lock = new DBSourceLock(targetId, target, this.threadSourceLock, this.dbLockDispose);
            this.expireTimeDispose.add(lock, expireTime);
            return lock;
        }
        catch (Throwable e) {
            try {
                if (onTargetAdd) {
                    this.dbLockNotifyQueue.remove(target);
                }
            }
            finally {
                this.threadSourceLock.unLock(target);
            }
            if (e instanceof HasLockedException) {
                throw (HasLockedException)e;
            }
            if (e instanceof Exception) {
                throw new LockException(target, "db process tryLock wait exception", (Exception)e);
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            throw new LockException(target, "db process tryLock wait exception");
        }
    }

    public void setDbLockDispose(IDBLockDispose dbLockDispose) {
        this.dbLockDispose = dbLockDispose;
    }

    public void setThreadSourceLock(ISourceThreadLock threadSourceLock) {
        this.threadSourceLock = threadSourceLock;
    }

    public void setDbLockNotifyQueue(IDBLockNotifyQueue dbLockNotifyQueue) {
        this.dbLockNotifyQueue = dbLockNotifyQueue;
    }

    public void setExpireTimeDispose(IExpireTimeDispose expireTimeDispose) {
        this.expireTimeDispose = expireTimeDispose;
    }

    public IDBLockDispose getDbLockDispose() {
        return this.dbLockDispose;
    }

    public IDBLockNotifyQueue getDbLockNotifyQueue() {
        return this.dbLockNotifyQueue;
    }

    public IExpireTimeDispose getExpireTimeDispose() {
        return this.expireTimeDispose;
    }
}

