/*
 * Decompiled with CFR 0.152.
 */
package com.hikvision.swdf.core.lock.db;

import com.hikvision.swdf.core.lock.db.IDBLockDispose;
import com.hikvision.swdf.core.lock.db.IDBLockNotifyQueue;
import com.ivms6.core.util.CollectionUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBLockNotifyQueue
implements IDBLockNotifyQueue,
Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(DBLockNotifyQueue.class);
    private static final String PRE_DB_TARGET = "*_";
    private IDBLockDispose dbLockDispose;
    private Lock lock = new ReentrantLock();
    private final Map<Object, Integer> queueMap = new HashMap<Object, Integer>();
    private volatile boolean onStart = false;
    private volatile boolean onNowAdd = false;
    private long intervalTime = 1000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Object target) {
        LOG.debug("add:target={}", target);
        this.lock.lock();
        try {
            Integer count = this.queueMap.get(target);
            if (count == null || count < 1) {
                count = 0;
            }
            this.queueMap.put(target, count + 1);
            this.onNowAdd = true;
            if (!this.onStart) {
                this.onStart = true;
                Thread thread = new Thread((Runnable)this, "DBLockNotifyQueue");
                thread.start();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("thread start");
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(Object target) {
        LOG.debug("remove:target={}", target);
        this.lock.lock();
        try {
            Integer count = this.queueMap.get(target);
            if (count != null && count > 1) {
                this.queueMap.put(target, count - 1);
            } else {
                this.queueMap.remove(target);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public long getIntervalTime() {
        return this.intervalTime;
    }

    public void setIntervalTime(long intervalTime) {
        this.intervalTime = intervalTime;
    }

    @Override
    public void run() {
        while (this.onStart) {
            this.onNowAdd = false;
            long intervalTime = this.getIntervalTime();
            if (intervalTime < 1L) continue;
            LOG.debug("Thread.sleep(intervalTime):{}", (Object)intervalTime);
            try {
                Thread.sleep(intervalTime);
            }
            catch (InterruptedException e) {
                LOG.error("Interrupted thread maybe interrupt", (Throwable)e);
            }
            this.doStart();
            if (this.onNowAdd || !CollectionUtils.isEmpty(this.queueMap)) continue;
            this.onStart = false;
        }
        LOG.debug("thread stop");
    }

    protected static Object toDBTarget(String target) {
        return (PRE_DB_TARGET + target).intern();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStart() {
        if (CollectionUtils.isEmpty(this.queueMap)) {
            return;
        }
        LOG.debug("doStart queueMap:{}", this.queueMap);
        String[] targets = this.queueMap.keySet().toArray(new String[0]);
        List<String> result = this.dbLockDispose.deleteNotUseAndReturn(targets);
        LOG.debug("deleteNotUseAndReturn:{}", result);
        if (CollectionUtils.isEmpty(result)) {
            return;
        }
        for (String target : result) {
            Object dbTarget;
            Object object = dbTarget = DBLockNotifyQueue.toDBTarget(target);
            synchronized (object) {
                if (this.queueMap.get(target) != null) {
                    dbTarget.notify();
                }
            }
        }
    }

    public void setDbLockDispose(IDBLockDispose dbLockDispose) {
        this.dbLockDispose = dbLockDispose;
    }
}

