/*
 * Decompiled with CFR 0.152.
 */
package com.hikvision.swdf.core.lock.db;

import com.hikvision.swdf.core.lock.ILock;
import com.hikvision.swdf.core.lock.ISourceThreadLock;
import com.hikvision.swdf.core.lock.IThreadLocalLock;
import com.hikvision.swdf.core.lock.LockException;
import com.hikvision.swdf.core.lock.LockStatistics;
import com.hikvision.swdf.core.lock.db.IDBLockDispose;

public class DBSourceLock
implements ILock,
IThreadLocalLock {
    private long targetId;
    private String target;
    private ISourceThreadLock threadSourceLock;
    private IDBLockDispose dbLockDispose;
    private volatile boolean hasUnLock;
    private boolean hasUnThreadLocalLock;

    protected DBSourceLock(long targetId, String target, ISourceThreadLock threadSourceLock, IDBLockDispose dbLockDispose) {
        this.targetId = targetId;
        this.target = target;
        this.threadSourceLock = threadSourceLock;
        this.dbLockDispose = dbLockDispose;
        this.hasUnLock = false;
        this.hasUnThreadLocalLock = false;
        LockStatistics.recordSuccess(target);
    }

    @Override
    public String getTarget() {
        return this.target;
    }

    public long getTargetId() {
        return this.targetId;
    }

    @Override
    public void unLock() throws LockException {
        this.unLock(true);
    }

    @Override
    public void unLock(boolean isCurrent) throws LockException {
        if (this.hasUnLock) {
            if (isCurrent && !this.hasUnThreadLocalLock) {
                this.threadSourceLock.unLock(this.target);
                this.hasUnThreadLocalLock = true;
            }
            return;
        }
        try {
            this.dbLockDispose.deleteByTargetId(this.targetId);
        }
        catch (Exception e) {
            throw new LockException(this.target, "unLock exception(db maybe not connect)", e);
        }
        this.threadSourceLock.unLock(this.target);
        if (isCurrent) {
            this.hasUnThreadLocalLock = true;
        }
        this.hasUnLock = true;
    }

    @Override
    public boolean hasUnLocked() {
        return this.hasUnLock;
    }
}

