/*
 * Decompiled with CFR 0.152.
 */
package com.hikvision.swdf.core.lock.file;

import com.hikvision.swdf.core.lock.ExpireLockBuilder;
import com.hikvision.swdf.core.lock.HasLockedException;
import com.hikvision.swdf.core.lock.ILock;
import com.hikvision.swdf.core.lock.ISourceThreadLock;
import com.hikvision.swdf.core.lock.LockException;
import com.hikvision.swdf.core.lock.NestedLockException;
import com.hikvision.swdf.core.lock.file.FileSourceLock;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileLockBuilder
extends ExpireLockBuilder {
    public static final Logger LOG = LoggerFactory.getLogger(FileLockBuilder.class);
    private static final String MODE = "rw";
    private ISourceThreadLock threadSourceLock;
    private String baseFilePath;

    public FileLockBuilder() {
    }

    public FileLockBuilder(int expireTime) {
        super(expireTime);
    }

    private File getFile(String target) {
        return new File(this.baseFilePath + target + ".lock");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ILock lockNoExpire(String target) throws LockException {
        int count = this.threadSourceLock.lock(target);
        if (count < 0) {
            throw new LockException(target, "file thread lock exception");
        }
        if (count > 0) {
            throw new NestedLockException(target, "thread lock is not support nested");
        }
        File file = null;
        RandomAccessFile randomAccessFile = null;
        FileLock fileLock = null;
        try {
            file = this.getFile(target);
            randomAccessFile = new RandomAccessFile(file, MODE);
            fileLock = randomAccessFile.getChannel().lock();
            return new FileSourceLock(target, this.threadSourceLock, fileLock, randomAccessFile, file, this.getExpireTimeDispose());
        }
        catch (Throwable e) {
            try {
                FileSourceLock.doCloseFile(file, randomAccessFile, fileLock);
            }
            finally {
                this.threadSourceLock.unLock(target);
            }
            if (e instanceof Exception) {
                throw new LockException(target, "file process lock exception", (Exception)e);
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            throw new LockException(target, "file process lock exception");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ILock tryLockNoExpire(String target) throws LockException {
        int count = this.threadSourceLock.tryLock(target);
        if (count < 0) {
            throw new HasLockedException(1, target, "file thread tryLock has locked");
        }
        if (count > 0) {
            throw new NestedLockException(target, "thread lock is not support nested");
        }
        File file = null;
        RandomAccessFile randomAccessFile = null;
        FileLock fileLock = null;
        try {
            file = this.getFile(target);
            randomAccessFile = new RandomAccessFile(file, MODE);
            fileLock = randomAccessFile.getChannel().tryLock();
            if (fileLock == null) {
                throw new HasLockedException(2, target, "file process tryLock has locked");
            }
            return new FileSourceLock(target, this.threadSourceLock, fileLock, randomAccessFile, file, this.getExpireTimeDispose());
        }
        catch (Throwable e) {
            try {
                FileSourceLock.doCloseFile(file, randomAccessFile, fileLock);
            }
            finally {
                this.threadSourceLock.unLock(target);
            }
            if (e instanceof HasLockedException) {
                throw (HasLockedException)e;
            }
            if (e instanceof Exception) {
                throw new LockException(target, "file process tryLock exception", (Exception)e);
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            throw new LockException(target, "file process tryLock exception");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ILock tryLockNoExpire(String target, long waitTime) throws LockException {
        long start = System.nanoTime() / 1000000L;
        int count = this.threadSourceLock.tryLock(target, waitTime);
        if (count < 0) {
            throw new HasLockedException(1, target, "file thread tryLock has locked");
        }
        if (count > 0) {
            throw new NestedLockException(target, "thread lock is not support nested");
        }
        File file = null;
        RandomAccessFile randomAccessFile = null;
        FileLock fileLock = null;
        try {
            long end;
            long dist;
            file = this.getFile(target);
            randomAccessFile = new RandomAccessFile(file, MODE);
            fileLock = null;
            while ((fileLock = randomAccessFile.getChannel().tryLock()) == null && (dist = waitTime - ((end = System.nanoTime() / 1000000L) - start)) > 0L) {
                Thread.sleep(dist > 1000L ? 1000L : dist);
            }
            if (fileLock == null) {
                throw new HasLockedException(2, target, "file process tryLock wait has locked");
            }
            return new FileSourceLock(target, this.threadSourceLock, fileLock, randomAccessFile, file, this.getExpireTimeDispose());
        }
        catch (Throwable e) {
            try {
                FileSourceLock.doCloseFile(file, randomAccessFile, fileLock);
            }
            finally {
                this.threadSourceLock.unLock(target);
            }
            if (e instanceof HasLockedException) {
                throw (HasLockedException)e;
            }
            if (e instanceof Exception) {
                throw new LockException(target, "file process tryLock wait exception", (Exception)e);
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            throw new LockException(target, "file process tryLock wait exception");
        }
    }

    public void setThreadSourceLock(ISourceThreadLock threadSourceLock) {
        this.threadSourceLock = threadSourceLock;
    }

    public void setBaseFilePath(String baseFilePath) {
        this.baseFilePath = baseFilePath;
    }

    public String getBaseFilePath() {
        return this.baseFilePath;
    }
}

