/*
 * Decompiled with CFR 0.152.
 */
package com.hikvision.swdf.core.lock.file;

import com.hikvision.swdf.core.lock.IExpireTimeDispose;
import com.hikvision.swdf.core.lock.ILock;
import com.hikvision.swdf.core.lock.ISourceThreadLock;
import com.hikvision.swdf.core.lock.IThreadLocalLock;
import com.hikvision.swdf.core.lock.LockException;
import com.hikvision.swdf.core.lock.LockStatistics;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSourceLock
implements ILock,
IThreadLocalLock {
    private static final Logger LOG = LoggerFactory.getLogger(FileSourceLock.class);
    private IExpireTimeDispose expireTimeDispose;
    private ISourceThreadLock threadSourceLock;
    private RandomAccessFile randomAccessFile;
    private FileLock fileLock;
    private String target;
    private File file;
    private volatile boolean hasUnLock;
    private boolean hasUnThreadLocalLock;

    protected FileSourceLock(String target, ISourceThreadLock threadSourceLock, FileLock fileLock, RandomAccessFile randomAccessFile, File file, IExpireTimeDispose expireTimeDispose) {
        this.target = target;
        this.threadSourceLock = threadSourceLock;
        this.fileLock = fileLock;
        this.randomAccessFile = randomAccessFile;
        this.file = file;
        this.hasUnLock = false;
        this.hasUnThreadLocalLock = false;
        this.expireTimeDispose = expireTimeDispose;
        LockStatistics.recordSuccess(target);
    }

    @Override
    public String getTarget() {
        return this.target;
    }

    @Override
    public void unLock() throws LockException {
        this.unLock(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unLock(boolean isCurrent) throws LockException {
        if (this.hasUnLock) {
            if (isCurrent && !this.hasUnThreadLocalLock) {
                this.threadSourceLock.unLock(this.target);
                this.hasUnThreadLocalLock = true;
            }
            return;
        }
        LockException exception = null;
        try {
            if (!FileSourceLock.doCloseFile(this.file, this.randomAccessFile, this.fileLock)) {
                exception = new LockException(this.target, "close exception");
            }
        }
        finally {
            this.threadSourceLock.unLock(this.target);
        }
        if (exception != null) {
            throw exception;
        }
        this.expireTimeDispose.remove(this);
        this.hasUnLock = true;
        if (isCurrent) {
            this.hasUnThreadLocalLock = true;
        }
    }

    public static boolean doCloseFile(File file, RandomAccessFile randomAccessFile, FileLock fileLock) {
        boolean result = true;
        if (fileLock != null) {
            try {
                fileLock.release();
            }
            catch (IOException e) {
                result = false;
                LOG.warn("fileLock.release IOException");
            }
        }
        if (randomAccessFile != null) {
            try {
                randomAccessFile.close();
            }
            catch (IOException e) {
                result = false;
                LOG.warn("randomAccessFile.close IOException");
            }
        }
        if (file != null && !file.delete()) {
            LOG.info("other process lock");
        }
        return result;
    }

    @Override
    public boolean hasUnLocked() {
        return this.hasUnLock;
    }
}

