/*
 * Decompiled with CFR 0.152.
 */
package com.hikvision.swdf.core.lock.thread;

import com.hikvision.swdf.core.lock.ExpireLockBuilder;
import com.hikvision.swdf.core.lock.HasLockedException;
import com.hikvision.swdf.core.lock.ILock;
import com.hikvision.swdf.core.lock.ISourceThreadLock;
import com.hikvision.swdf.core.lock.LockException;
import com.hikvision.swdf.core.lock.NestedLockException;
import com.hikvision.swdf.core.lock.thread.ThreadSourceLock;

public class ThreadLockBuilder
extends ExpireLockBuilder {
    private ISourceThreadLock threadSourceLock;

    @Override
    public ILock lockNoExpire(String target) throws LockException {
        int count = this.threadSourceLock.lock(target);
        if (count < 0) {
            throw new LockException(target, "thread lock fails");
        }
        if (count > 0) {
            throw new NestedLockException(target, "thread lock is not support nested" + count);
        }
        return new ThreadSourceLock(target, this.threadSourceLock, this.getExpireTimeDispose());
    }

    @Override
    public ILock tryLockNoExpire(String target) throws LockException {
        int count = this.threadSourceLock.tryLock(target);
        if (count < 0) {
            throw new HasLockedException(1, target, "thread tryLock has locked");
        }
        if (count > 0) {
            throw new NestedLockException(target, "thread lock is not support nested" + count);
        }
        return new ThreadSourceLock(target, this.threadSourceLock, this.getExpireTimeDispose());
    }

    @Override
    public ILock tryLockNoExpire(String target, long waitTime) throws LockException {
        int count = this.threadSourceLock.tryLock(target, waitTime);
        if (count < 0) {
            throw new HasLockedException(1, target, "thread tryLock wait has locked");
        }
        if (count > 0) {
            throw new NestedLockException(target, "thread lock is not support nested");
        }
        return new ThreadSourceLock(target, this.threadSourceLock, this.getExpireTimeDispose());
    }

    public void setThreadSourceLock(ISourceThreadLock threadSourceLock) {
        this.threadSourceLock = threadSourceLock;
    }
}

