/*
 * Decompiled with CFR 0.152.
 */
package com.hikvision.swdf.core.lock.thread;

import com.hikvision.swdf.core.lock.IExpireTimeDispose;
import com.hikvision.swdf.core.lock.ILock;
import com.hikvision.swdf.core.lock.ISourceThreadLock;
import com.hikvision.swdf.core.lock.IThreadLocalLock;
import com.hikvision.swdf.core.lock.LockException;
import com.hikvision.swdf.core.lock.LockStatistics;

public class ThreadSourceLock
implements ILock,
IThreadLocalLock {
    private IExpireTimeDispose expireTimeDispose;
    private String target;
    private ISourceThreadLock threadSourceLock;
    private volatile boolean hasUnLock;
    private boolean hasUnThreadLocalLock;

    protected ThreadSourceLock(String target, ISourceThreadLock threadSourceLock, IExpireTimeDispose expireTimeDispose) {
        this.target = target;
        this.threadSourceLock = threadSourceLock;
        this.hasUnLock = false;
        this.hasUnThreadLocalLock = false;
        this.expireTimeDispose = expireTimeDispose;
        LockStatistics.recordSuccess(target);
    }

    @Override
    public String getTarget() {
        return this.target;
    }

    @Override
    public void unLock() throws LockException {
        this.unLock(true);
    }

    @Override
    public void unLock(boolean isCurrent) throws LockException {
        if (this.hasUnLock) {
            if (isCurrent && !this.hasUnThreadLocalLock) {
                this.threadSourceLock.unLock(this.target);
                this.hasUnThreadLocalLock = true;
            }
            return;
        }
        this.expireTimeDispose.remove(this);
        this.threadSourceLock.unLock(this.target);
        this.hasUnLock = true;
        if (isCurrent) {
            this.hasUnThreadLocalLock = true;
        }
    }

    @Override
    public boolean hasUnLocked() {
        return this.hasUnLock;
    }
}

