/*
 * Decompiled with CFR 0.152.
 */
package com.hikvision.swdf.core.log;

import com.hikvision.swdf.core.ServiceLocator;
import com.hikvision.swdf.core.executor.ThreadExecutorService;
import com.hikvision.swdf.core.log.IOperationLogger;
import com.hikvision.swdf.core.log.OperationLogBo;
import com.hikvision.swdf.core.task.AbstractTaskEntity;
import com.ivms6.core.util.CollectionUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogQueueTask
extends AbstractTaskEntity {
    private static final Logger log = LoggerFactory.getLogger(LogQueueTask.class);
    private static ConcurrentLinkedQueue<OperationLogBo> queue = new ConcurrentLinkedQueue();
    private static IOperationLogger operationLogger = (IOperationLogger)ServiceLocator.findService("operationLogger");

    public static void setQueue(OperationLogBo obj) {
        List<OperationLogBo> list = LogQueueTask.check(false);
        if (CollectionUtils.isNotEmpty(list)) {
            ThreadExecutorService.execute(LogQueueTask.queueTask(list));
        }
        queue.add(obj);
        log.debug("setqueue size:" + queue.size());
    }

    private static synchronized List<OperationLogBo> check(boolean flag) {
        if (flag || queue.size() == 999) {
            Iterator<OperationLogBo> iterator = queue.iterator();
            ArrayList<OperationLogBo> list = new ArrayList<OperationLogBo>();
            while (iterator.hasNext()) {
                list.add(iterator.next());
            }
            queue.clear();
            return list;
        }
        return null;
    }

    private static Runnable queueTask(final List<OperationLogBo> list) {
        return new Runnable(){

            @Override
            public void run() {
                for (OperationLogBo bo : list) {
                    if (operationLogger == null) continue;
                    operationLogger.log(bo, true);
                }
            }
        };
    }

    @Override
    public void run() {
        log.info("LogQueue Save Task start ...");
        List<OperationLogBo> list = LogQueueTask.check(true);
        if (CollectionUtils.isNotEmpty(list)) {
            ThreadExecutorService.execute(LogQueueTask.queueTask(list));
        }
    }
}

