/*
 * Decompiled with CFR 0.152.
 */
package com.hikvision.swdf.core.log;

import com.hikvision.swdf.core.log.LogResultType;
import com.hikvision.swdf.core.log.OperationLogUtil;
import com.hikvision.swdf.util.LocaleTextUtil;
import com.ivms6.core.util.NumberUtils;
import com.ivms6.core.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OperationContentBo {
    private String operateObjectType;
    private Map<String, String> operateObjectMap;
    private Map<Long, String> objectOrgMap;
    private Map<String, Object> newParamMap;
    private Map<String, Object> oldParamMap;
    private LogResultType operateResult = LogResultType.SUCCESS;
    private String content;

    public OperationContentBo() {
    }

    public OperationContentBo(String operateObjectType, Map<String, String> operateObjectMap, Map<Long, String> objectOrgMap, Map<String, Object> newParamMap, Map<String, Object> oldParamMap, String content) {
        if (operateObjectType != null) {
            this.operateObjectType = operateObjectType;
        }
        if (StringUtils.isNotBlank((String)content)) {
            this.content = content;
        }
        if (operateObjectMap != null) {
            this.operateObjectMap = operateObjectMap;
        }
        if (objectOrgMap != null) {
            this.objectOrgMap = objectOrgMap;
        }
        if (newParamMap != null) {
            this.newParamMap = newParamMap;
        }
        if (oldParamMap != null) {
            this.oldParamMap = oldParamMap;
        }
    }

    public void addOperateObject(String key, String name) {
        this.getOperateObjectMap().put(key, name);
    }

    public void setOperateObjectMap(Map<String, String> operateObjectMap) {
        this.operateObjectMap = operateObjectMap;
    }

    public void addObjectOrg(Long orgId, String orgName) {
        this.getObjectOrgMap().put(orgId, orgName);
    }

    public void setObjectOrgMap(Map<Long, String> objectOrgMap) {
        this.objectOrgMap = objectOrgMap;
    }

    public void addNewParam(String key, String value) {
        Object o = this.getNewParamMap().get(key);
        if (o == null) {
            this.getNewParamMap().put(key, value);
        } else if (o instanceof String) {
            ArrayList<String> values = new ArrayList<String>();
            values.add(o.toString());
            values.add(value);
            this.getNewParamMap().put(key, values);
        } else if (o instanceof List) {
            List values = (List)o;
            values.add(value);
        }
    }

    public void setNewParamMap(Map<String, Object> newParamMap) {
        this.newParamMap = newParamMap;
    }

    public void addOldParam(String key, String value) {
        Object o = this.getOldParamMap().get(key);
        if (o == null) {
            this.getOldParamMap().put(key, value);
        } else if (o instanceof String) {
            ArrayList<String> values = new ArrayList<String>();
            values.add(o.toString());
            values.add(value);
            this.getOldParamMap().put(key, values);
        } else if (o instanceof List) {
            List values = (List)o;
            values.add(value);
        }
    }

    public void setOldParamMap(Map<String, Object> oldParamMap) {
        this.oldParamMap = oldParamMap;
    }

    public String getOperateObjectType() {
        if (this.operateObjectType == null) {
            return "";
        }
        return this.operateObjectType;
    }

    public void setOperateObject(String operateObjectType) {
        this.operateObjectType = operateObjectType;
    }

    public Integer getOperateResult() {
        return this.operateResult.getValue();
    }

    public void setOperateResult(LogResultType operateResult) {
        this.operateResult = operateResult;
    }

    public String getContent() {
        if (StringUtils.isNotBlank((String)this.content)) {
            while (this.content.indexOf("{") >= 0 && this.content.indexOf("}") > 0 && this.content.indexOf("{") < this.content.indexOf("}")) {
                List values;
                Object o;
                String p;
                String c = this.content.substring(this.content.indexOf("{"), this.content.indexOf("}") + 1);
                String value = "[]";
                if (c.startsWith("{obj.")) {
                    p = c.substring(c.indexOf("{obj.") + 5, c.indexOf("}"));
                    if (StringUtils.isNotBlank((String)p)) {
                        value = StringUtils.defaultIfBlank((String)this.operateObjectMap.get(p), (String)value);
                    }
                } else if (c.startsWith("{org.")) {
                    p = c.substring(c.indexOf("{org.") + 5, c.indexOf("}"));
                    if (StringUtils.isNotBlank((String)p)) {
                        value = StringUtils.defaultIfBlank((String)this.objectOrgMap.get(NumberUtils.toLong((String)p)), (String)value);
                    }
                } else if (c.startsWith("{new.")) {
                    p = c.substring(c.indexOf("{new.") + 5, c.indexOf("}"));
                    if (StringUtils.isNotBlank((String)p) && (o = this.newParamMap.get(p)) != null) {
                        if (o instanceof String) {
                            value = StringUtils.defaultIfBlank((String)o.toString(), (String)value);
                        } else if (o instanceof List) {
                            values = (List)o;
                            value = StringUtils.defaultIfBlank((String)String.valueOf(values.size()), (String)value);
                        }
                    }
                } else if (c.startsWith("{old.")) {
                    p = c.substring(c.indexOf("{old.") + 5, c.indexOf("}"));
                    if (StringUtils.isNotBlank((String)p) && (o = this.oldParamMap.get(p)) != null) {
                        if (o instanceof String) {
                            value = StringUtils.defaultIfBlank((String)o.toString(), (String)value);
                        } else if (o instanceof List) {
                            values = (List)o;
                            value = StringUtils.defaultIfBlank((String)String.valueOf(values.size()), (String)value);
                        }
                    }
                } else if (c.startsWith("{type}")) {
                    if (this.operateObjectType == null) {
                        String unknowType = LocaleTextUtil.getLocalText("operate.objtype.unknown");
                        if (StringUtils.isEmpty((String)unknowType)) {
                            unknowType = "\u672a\u77e5";
                        }
                        this.operateObjectType = unknowType;
                    }
                    value = this.operateObjectType;
                }
                this.content = StringUtils.replace((String)this.content, (String)c, (String)value);
            }
        }
        return this.content;
    }

    public void setContent(String content) {
        this.content = StringUtils.replace((String)content, (String)"{loginName}", (String)OperationLogUtil.getOperator());
    }

    private Map<String, String> getOperateObjectMap() {
        if (this.operateObjectMap == null) {
            this.operateObjectMap = new HashMap<String, String>();
        }
        return this.operateObjectMap;
    }

    public String getOperateObjectKeys() {
        String operateObjectKeys = "";
        if (this.operateObjectMap != null && !this.operateObjectMap.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, String> entry : this.operateObjectMap.entrySet()) {
                if (StringUtils.isEmpty((String)entry.getKey())) continue;
                sb.append("[").append(entry.getKey()).append("]");
            }
            operateObjectKeys = sb.toString();
        }
        return operateObjectKeys;
    }

    public String getOperateObjectValues() {
        String operateObjectValues = "";
        if (this.operateObjectMap != null && !this.operateObjectMap.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, String> entry : this.operateObjectMap.entrySet()) {
                if (StringUtils.isEmpty((String)entry.getValue())) continue;
                sb.append("[").append(entry.getValue()).append("]");
            }
            operateObjectValues = sb.toString();
        }
        return operateObjectValues;
    }

    public String getObjectOrgIds() {
        String objectOrgIds = "";
        if (this.objectOrgMap != null && !this.objectOrgMap.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<Long, String> entry : this.objectOrgMap.entrySet()) {
                sb.append("[").append(NumberUtils.null2zero((Long)entry.getKey())).append("]");
            }
            objectOrgIds = sb.toString();
        }
        return objectOrgIds;
    }

    public String getObjectOrgNames() {
        String objectOrgNames = "";
        if (this.objectOrgMap != null && !this.objectOrgMap.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<Long, String> entry : this.objectOrgMap.entrySet()) {
                sb.append("[").append(entry.getValue()).append("]");
            }
            objectOrgNames = sb.toString();
        }
        return objectOrgNames;
    }

    private Map<Long, String> getObjectOrgMap() {
        if (this.objectOrgMap == null) {
            this.objectOrgMap = new HashMap<Long, String>();
        }
        return this.objectOrgMap;
    }

    public Map<String, Object> getNewParamMap() {
        if (this.newParamMap == null) {
            this.newParamMap = new HashMap<String, Object>();
        }
        return this.newParamMap;
    }

    public Map<String, Object> getOldParamMap() {
        if (this.oldParamMap == null) {
            this.oldParamMap = new HashMap<String, Object>();
        }
        return this.oldParamMap;
    }
}

