/*
 * Decompiled with CFR 0.152.
 */
package com.hikvision.swdf.core.notify;

import com.hikvision.swdf.core.ServiceLocator;
import com.hikvision.swdf.core.notify.INotifyPersistence;
import com.hikvision.swdf.core.notify.Notifiable;
import com.hikvision.swdf.core.notify.NotifierRegistedException;
import com.hikvision.swdf.core.notify.NotifyBo;
import com.ivms6.core.util.BeanUtils;
import com.ivms6.core.util.CollectionUtils;
import com.ivms6.core.util.StringUtils;
import com.ivms6.core.util.cm.ConfigManager;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotifyManager {
    private static Logger log = LoggerFactory.getLogger(NotifyManager.class);
    private static List<String> events = new CopyOnWriteArrayList<String>();
    private static boolean ENABLE = true;
    private static Map<String, List<Notifiable>> listenersMap = new ConcurrentHashMap<String, List<Notifiable>>();
    private static ExecutorService executor = null;
    private static long lastResend;
    private static long resendTime;
    private static ThreadLocal<Set<String>> notifyMsg;
    private static INotifyPersistence notifyPersistence;

    public static void disableNotify() {
        log.info("disable notify.");
        ENABLE = false;
    }

    public static void enableNotify() {
        log.info("enable notify.");
        ENABLE = true;
    }

    public static boolean isNotifierExist(String notifierType) {
        return events.contains(notifierType);
    }

    public static synchronized boolean createNotifier(String event) throws NotifierRegistedException {
        if (NotifyManager.isNotifierExist(event)) {
            throw new NotifierRegistedException("notifier '" + event + "' is exist.");
        }
        events.add(event);
        Vector list = new Vector();
        listenersMap.put(event, list);
        log.info("notifier '" + event + "' is created.");
        return true;
    }

    public static synchronized boolean removeNotifier(String event) {
        events.remove(event);
        listenersMap.remove(event);
        return true;
    }

    public static synchronized boolean registerListener(String event, Notifiable listener) {
        try {
            NotifyManager.createNotifier(event);
        }
        catch (NotifierRegistedException e) {
            log.debug("duplicate event\uff1a" + event);
        }
        List<Notifiable> list = listenersMap.get(event);
        if (list.contains(listener)) {
            log.info("listener has been registed." + listener);
            return false;
        }
        list.add(listener);
        log.info("listener '" + listener + "' is registed. the notifier is " + event);
        return true;
    }

    public static synchronized boolean unRegisterListener(String event, Notifiable listener) {
        List<Notifiable> notify = listenersMap.get(event);
        if (notify != null) {
            notify.remove(listener);
        }
        return true;
    }

    public static synchronized boolean unRegisterListener(String event, String listenerId) {
        List<Notifiable> notifys = listenersMap.get(event);
        if (notifys == null) {
            return false;
        }
        Notifiable deleteOne = null;
        for (Notifiable notify : notifys) {
            if (notify.getIdentify() == null || !notify.getIdentify().equals(listenerId)) continue;
            deleteOne = notify;
            break;
        }
        if (deleteOne != null) {
            notifys.remove(deleteOne);
        }
        return true;
    }

    public static List<Notifiable> getNotifiier(String event) {
        List<Notifiable> notifierList = listenersMap.get(event);
        return notifierList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendNotify() {
        Set<String> eventList;
        block7: {
            block6: {
                eventList = notifyMsg.get();
                if (ENABLE) break block6;
                log.info("notify is disable.");
                notifyMsg.remove();
                NotifyManager.resendNotify(eventList == null ? Collections.EMPTY_SET : eventList);
                return;
            }
            if (!CollectionUtils.isEmpty(eventList)) break block7;
            notifyMsg.remove();
            NotifyManager.resendNotify(eventList == null ? Collections.EMPTY_SET : eventList);
            return;
        }
        try {
            log.info("send all notify:" + eventList.size());
            for (final String event : eventList) {
                log.info("send a notify:" + event);
                List<Notifiable> observers = NotifyManager.getNotifiier(event);
                if (observers == null) continue;
                for (final Notifiable o : observers) {
                    executor.execute(new Runnable(){

                        @Override
                        public void run() {
                            log.info("send a notify:" + event + ",listener:" + o.getClass().getName());
                            o.notifys(event);
                        }
                    });
                }
            }
            notifyMsg.remove();
            NotifyManager.resendNotify(eventList == null ? Collections.EMPTY_SET : eventList);
        }
        catch (Throwable throwable) {
            notifyMsg.remove();
            NotifyManager.resendNotify(eventList == null ? Collections.EMPTY_SET : eventList);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sendNotify0() {
        try {
            if (!ENABLE) {
                log.info("notify is disable.");
                return;
            }
            Set<String> eventList = notifyMsg.get();
            if (CollectionUtils.isEmpty(eventList)) {
                return;
            }
            log.info("send all notify:" + eventList.size());
            for (final String event : eventList) {
                log.info("send a notify:" + event);
                List<Notifiable> observers = NotifyManager.getNotifiier(event);
                if (observers == null) continue;
                for (final Notifiable o : observers) {
                    executor.execute(new Runnable(){

                        @Override
                        public void run() {
                            log.info("send a notify:" + event + ",listener:" + o.getClass().getName());
                            o.notifys(event);
                        }
                    });
                }
            }
        }
        finally {
            notifyMsg.remove();
        }
    }

    private static void resendNotify(final Set<String> eventList) {
        final long now = System.currentTimeMillis();
        if (now - resendTime > lastResend) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    log.info("start query resend notify.");
                    List<String> events = NotifyManager.getNotifyPersistence().queryReSendNotify();
                    if (CollectionUtils.isEmpty(events)) {
                        log.info("no event 4 resend.");
                        return;
                    }
                    for (String event : events) {
                        if (eventList.contains(event)) continue;
                        log.info("add resend event:{}", new Object[]{event});
                        NotifyManager.addNotifyEvent(event);
                    }
                    NotifyManager.sendNotify0();
                    lastResend = now;
                }
            });
        }
    }

    public static boolean cancelNotify() {
        if (!CollectionUtils.isEmpty((Collection)notifyMsg.get())) {
            log.info("clear all notify.");
        }
        notifyMsg.remove();
        return true;
    }

    public static void addNotify(String event, NotifyBo notify) {
        log.info("add a notify:" + event);
        Set<String> eventList = notifyMsg.get();
        if (eventList == null) {
            eventList = new HashSet<String>();
        }
        eventList.add(event);
        notify.setEvent(event);
        notifyMsg.set(eventList);
        List<Notifiable> observers = NotifyManager.getNotifiier(event);
        if (!CollectionUtils.isEmpty(observers)) {
            for (Notifiable observer : observers) {
                try {
                    NotifyBo splitNotify = (NotifyBo)BeanUtils.cloneBean((Object)notify);
                    splitNotify.setListener(observer.getIdentify());
                    NotifyManager.getNotifyPersistence().persist(splitNotify);
                }
                catch (IllegalAccessException e) {
                    log.error("persist notify data error.", (Throwable)e);
                }
                catch (InstantiationException e) {
                    log.error("persist notify data error.", (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    log.error("persist notify data error.", (Throwable)e);
                }
                catch (NoSuchMethodException e) {
                    log.error("persist notify data error.", (Throwable)e);
                }
            }
        }
    }

    public static void addNotifyEvent(String event) {
        log.info("add a notify:" + event);
        Set<String> eventList = notifyMsg.get();
        if (CollectionUtils.isEmpty(eventList)) {
            eventList = new HashSet<String>();
        }
        eventList.add(event);
        notifyMsg.set(eventList);
    }

    public static void addNotify(String event, List<NotifyBo> notifyList) {
        if (CollectionUtils.isEmpty(notifyList)) {
            return;
        }
        for (NotifyBo notify : notifyList) {
            NotifyManager.addNotify(event, notify);
        }
    }

    public static List<String> events() {
        return events;
    }

    private static INotifyPersistence getNotifyPersistence() {
        if (notifyPersistence == null) {
            notifyPersistence = (INotifyPersistence)ServiceLocator.findService("notifyPersistence");
        }
        return notifyPersistence;
    }

    public static List<NotifyBo> queryNotify(String dataType, String listener) {
        return NotifyManager.getNotifyPersistence().queryNotify(dataType, listener);
    }

    public static List<NotifyBo> queryNotify(String dataType, String listener, int start, int limit) {
        return NotifyManager.getNotifyPersistence().queryNotify(dataType, listener, start, limit);
    }

    public static List<NotifyBo> queryNotify(String listener) {
        return NotifyManager.getNotifyPersistence().queryNotify(listener);
    }

    public static List<NotifyBo> queryNotify(String listener, int start, int limit) {
        return NotifyManager.getNotifyPersistence().queryNotify(listener, start, limit);
    }

    public static void deleteNotifyById(Long id) {
        NotifyManager.getNotifyPersistence().deleteNotifyById(id);
    }

    public static void deleteNotifyByIds(List<Long> ids) {
        NotifyManager.getNotifyPersistence().deleteNotifyByIds(ids);
    }

    public static ExecutorService getExecutor() {
        return executor;
    }

    public static boolean isEnable() {
        return ENABLE;
    }

    public static List<String> getEvents() {
        return events;
    }

    public static Map<String, List<Notifiable>> getListeners() {
        return listenersMap;
    }

    static {
        String configThreadCount = ConfigManager.getConfiguration((String)"thread-config", (String)"notify.thread.count");
        if (StringUtils.isEmpty((String)configThreadCount) || !StringUtils.isNumeric((String)configThreadCount)) {
            configThreadCount = "10";
        }
        executor = Executors.newFixedThreadPool(Integer.parseInt(configThreadCount));
        lastResend = 0L;
        resendTime = 36000000L;
        notifyMsg = new ThreadLocal();
    }
}

