/*
 * Decompiled with CFR 0.152.
 */
package com.hikvision.swdf.core.notify;

import com.hikvision.swdf.core.notify.Notifiable;
import com.hikvision.swdf.core.notify.NotifyManager;
import com.ivms6.core.util.cm.ConfigManager;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotifySendThread
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(NotifySendThread.class);
    private static LinkedBlockingQueue<String> queue = new LinkedBlockingQueue(50);
    private static NotifySendThread instence = new NotifySendThread();
    private static ExecutorService executor = null;

    private NotifySendThread() {
    }

    public static NotifySendThread getInstance() {
        if (!instence.isAlive()) {
            instence.start();
        }
        return instence;
    }

    public synchronized void addToQueue(String event) {
        log.debug("try add a event.[]", new Object[]{event});
        if (!queue.contains(event)) {
            log.debug("add a listener.[]", new Object[]{event});
            queue.add(event);
        }
    }

    public static ExecutorService getExecutor() {
        return executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block4: while (true) {
            try {
                List<Notifiable> observers;
                String event;
                while ((event = queue.take()) == null || (observers = NotifyManager.getNotifiier(event)) == null) {
                }
                Iterator<Notifiable> i$ = observers.iterator();
                while (true) {
                    if (!i$.hasNext()) continue block4;
                    final Notifiable o = i$.next();
                    executor.execute(new Runnable(){

                        @Override
                        public void run() {
                            log.info("send a notify:" + event + ",listener:" + o.getClass().getName());
                            o.notifys(event);
                        }
                    });
                }
            }
            catch (Exception e) {
                log.error("NotifySendThread run exception", (Throwable)e);
            }
        }
    }

    static {
        String configThreadCount = ConfigManager.getConfiguration((String)"thread-config", (String)"notify.thread.count");
        if (StringUtils.isEmpty((String)configThreadCount) || !StringUtils.isNumeric((String)configThreadCount)) {
            configThreadCount = "10";
        }
        executor = Executors.newFixedThreadPool(Integer.parseInt(configThreadCount));
    }
}

