/*
 * Decompiled with CFR 0.152.
 */
package com.hikvision.swdf.core.notify.cleaner;

import com.hikvision.swdf.core.ServiceLocator;
import com.hikvision.swdf.core.notify.INotifyPersistence;
import com.hikvision.swdf.core.notify.cleaner.INotifyDataCleaner;
import com.ivms6.core.util.StringUtils;
import com.ivms6.core.util.cm.ConfigManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultNotifyDataCleaner
implements INotifyDataCleaner {
    private static Logger log = LoggerFactory.getLogger(DefaultNotifyDataCleaner.class);
    private INotifyPersistence notifyPersistence;
    private int default_expire = 7;

    @Override
    public void clean() {
        int expire = this.default_expire;
        try {
            String expireStr = ConfigManager.getConfiguration((String)"notify-config", (String)"clean.expire");
            if (StringUtils.isNumeric((String)expireStr)) {
                expire = Integer.parseInt(expireStr);
            }
        }
        catch (Exception e) {
            log.error("get clean expire error,use default 7", (Throwable)e);
        }
        log.info("clean expire notify data,the expire is {}", new Object[]{expire});
        this.getNotifyPersistence().cleanExpireNotifyData(expire);
    }

    public INotifyPersistence getNotifyPersistence() {
        if (this.notifyPersistence == null) {
            this.notifyPersistence = (INotifyPersistence)ServiceLocator.findService("notifyPersistence");
        }
        return this.notifyPersistence;
    }

    public void setNotifyPersistence(INotifyPersistence notifyPersistence) {
        this.notifyPersistence = notifyPersistence;
    }
}

