/*
 * Decompiled with CFR 0.152.
 */
package com.hikvision.swdf.core.notify.protocol;

import com.ivms6.core.util.CollectionUtils;
import com.ivms6.core.util.StringUtils;
import com.ivms6.core.util.cm.ConfigManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ListenerProtocol {
    private String protocol;
    private String url;
    private String id;
    private List<String> events = new ArrayList<String>();
    private Map<String, String> params = new HashMap<String, String>();

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getUrl() {
        if (this.url == null || StringUtils.isEmpty((String)this.url)) {
            return "";
        }
        if (this.url.contains("${") && this.url.contains("}")) {
            this.url = this.formatUrl(this.url);
        }
        return this.url;
    }

    private String formatUrl(String url) {
        boolean formateStart = false;
        boolean isEscape = false;
        boolean hasDoll = false;
        StringBuilder sb = new StringBuilder(20);
        sb.append("${");
        HashMap<String, String> replaceTemp = new HashMap<String, String>();
        for (char u : url.toCharArray()) {
            if (u == '\\') {
                isEscape = true;
            } else if (u == '$' && !isEscape) {
                hasDoll = true;
            } else if (u == '}' && formateStart) {
                formateStart = false;
                sb.append("}");
                String paramName = sb.toString();
                String replaceName = ConfigManager.getConfiguration((String)"service-param", (String)paramName.substring(2, paramName.length() - 1));
                replaceTemp.put(paramName, replaceName);
                sb = new StringBuilder(20);
                sb.append("${");
            } else if (u == '{' && hasDoll) {
                formateStart = true;
                hasDoll = false;
            } else if (formateStart) {
                sb.append(u);
            }
            if (u == '\\') continue;
            isEscape = false;
        }
        String result = url = url.replace("\\$", "%#%");
        if (!CollectionUtils.isEmpty(replaceTemp)) {
            for (Map.Entry entry : replaceTemp.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (value == null) continue;
                result = result.replace(key, value);
            }
        }
        result = result.replace("%#%", "$");
        return result;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public void setParams(Map<String, String> params) {
        this.params = params;
    }

    public void addParam(String paramKey, String paramValue) {
        this.params.put(paramKey, paramValue);
    }

    public String getParam(String paramKey) {
        return this.params.get(paramKey);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<String> getEvents() {
        return this.events;
    }

    public void setEvents(List<String> events) {
        this.events = events;
    }

    public void addEvent(String event) {
        this.events.add(event);
    }
}

