/*
 * Decompiled with CFR 0.152.
 */
package com.hikvision.swdf.core.notify.register;

import com.hikvision.swdf.core.notify.Notifiable;
import com.hikvision.swdf.core.notify.NotifyManager;
import com.hikvision.swdf.core.notify.protocol.ListenerProtocol;
import com.hikvision.swdf.core.notify.register.HttpNotifier;
import com.hikvision.swdf.core.notify.register.IListenerRegister;
import com.ivms6.core.util.CollectionUtils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpListenerRegister
implements IListenerRegister {
    private static Logger log = LoggerFactory.getLogger(HttpListenerRegister.class);

    @Override
    public void regist(ListenerProtocol protocol) {
        Notifiable l = this.getListener(protocol);
        if (l == null) {
            log.warn("can't find notifiable bean which name is '" + protocol.getId() + "'.");
            return;
        }
        List<String> events = protocol.getEvents();
        if (CollectionUtils.isEmpty(events)) {
            log.warn("the protocol does not contain the event.");
            return;
        }
        for (String e : events) {
            NotifyManager.registerListener(e, l);
        }
    }

    private Notifiable getListener(ListenerProtocol protocol) {
        HttpNotifier listener = new HttpNotifier(protocol);
        return listener;
    }
}

