/*
 * Decompiled with CFR 0.152.
 */
package com.hikvision.swdf.core.notify.register;

import com.hikvision.swdf.core.notify.Notifiable;
import com.hikvision.swdf.core.notify.protocol.ListenerProtocol;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpNotifier
implements Notifiable {
    private static Logger log = LoggerFactory.getLogger(HttpNotifier.class);
    private ListenerProtocol protocol;

    public HttpNotifier() {
    }

    public HttpNotifier(ListenerProtocol protocol) {
        this.protocol = protocol;
    }

    @Override
    public String getIdentify() {
        return this.protocol.getId();
    }

    @Override
    public void setIdentify(String identify) {
        this.protocol.setId(identify);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifys(String event) {
        String urlStr = "http://" + this.protocol.getUrl() + "?event=" + event + "&id=" + this.protocol.getId();
        HttpURLConnection httpUrlConnection = null;
        try {
            log.info("send http notify,target:{},event:{},id:{},protocol Id:{}", new Object[]{urlStr, event, this.getIdentify(), this.protocol.getId()});
            URL url = new URL(urlStr);
            URLConnection urlConnection = url.openConnection();
            httpUrlConnection = (HttpURLConnection)urlConnection;
            httpUrlConnection.setRequestMethod("POST");
            httpUrlConnection.setUseCaches(false);
            httpUrlConnection.setConnectTimeout(5000);
            httpUrlConnection.setReadTimeout(5000);
            httpUrlConnection.connect();
            int resCode = httpUrlConnection.getResponseCode();
            if (resCode == 200) {
                log.info("send notify successfully");
            } else {
                log.info("send notify error,resCode is {}", new Object[]{resCode});
            }
        }
        catch (Exception e) {
            log.error("call ws to notify listener " + this.protocol.getId() + " fail.", (Throwable)e);
        }
        finally {
            if (httpUrlConnection != null) {
                httpUrlConnection.disconnect();
            }
        }
    }

    public ListenerProtocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(ListenerProtocol protocol) {
        this.protocol = protocol;
    }
}

