/*
 * Decompiled with CFR 0.152.
 */
package com.hikvision.swdf.core.notify.register;

import com.hikvision.swdf.core.ServiceLocator;
import com.hikvision.swdf.core.notify.Notifiable;
import com.hikvision.swdf.core.notify.NotifyManager;
import com.hikvision.swdf.core.notify.protocol.ListenerProtocol;
import com.hikvision.swdf.core.notify.register.IListenerRegister;
import com.ivms6.core.util.CollectionUtils;
import com.ivms6.core.util.GenericsUtil;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalListenerRegister
implements IListenerRegister {
    private static Logger log = LoggerFactory.getLogger(LocalListenerRegister.class);

    public Notifiable getListener(String id) {
        Notifiable listener = (Notifiable)ServiceLocator.findService(id);
        return listener;
    }

    public Notifiable createListener(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            if (GenericsUtil.isImplements(clazz, (String)Notifiable.class.getCanonicalName())) {
                return (Notifiable)clazz.newInstance();
            }
        }
        catch (ClassNotFoundException e) {
            log.warn("local class name is wrong.", (Throwable)e);
        }
        catch (InstantiationException e) {
            log.warn("local class name is wrong.", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.warn("local class name is wrong.", (Throwable)e);
        }
        return null;
    }

    @Override
    public void regist(ListenerProtocol protocol) {
        List<String> events;
        Notifiable l = this.getListener(protocol.getId());
        if (l == null) {
            log.warn("can't find notifiable bean which name is '" + protocol.getId() + "'.");
            l = this.createListener(protocol.getUrl());
            if (l == null) {
                log.warn("can't create notifiable object which class name is '" + protocol.getUrl() + "'.");
                return;
            }
        }
        if (CollectionUtils.isEmpty(events = protocol.getEvents())) {
            log.warn("the protocol does not contain the event.");
            return;
        }
        l.setIdentify(protocol.getId());
        for (String e : events) {
            NotifyManager.registerListener(e, l);
        }
    }
}

