/*
 * Decompiled with CFR 0.152.
 */
package com.hikvision.swdf.core.notify.register;

import com.hikvision.swdf.core.ServiceLocator;
import com.hikvision.swdf.core.notify.protocol.ListenerProtocol;
import com.hikvision.swdf.core.notify.register.IListenerRegister;
import com.hikvision.swdf.core.notify.register.IRegisterFactory;
import com.ivms6.core.util.CollectionUtils;
import com.ivms6.core.util.StringUtils;
import com.ivms6.core.util.cm.ConfigManager;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticConfigRegisterFactory
implements IRegisterFactory {
    private static Logger log = LoggerFactory.getLogger(StaticConfigRegisterFactory.class);
    private final String NOTIFY_SECTION = "notify-regist";
    private final String PROTOCOL_SPLIT = "://";

    @Override
    public IListenerRegister createRegister(String protocol) {
        if ("local".equals(protocol)) {
            return (IListenerRegister)ServiceLocator.findService("localListenerRegister");
        }
        if ("ws".equals(protocol)) {
            return (IListenerRegister)ServiceLocator.findService("wsListenerRegister");
        }
        if ("http".equals(protocol)) {
            return (IListenerRegister)ServiceLocator.findService("httpListenerRegister");
        }
        return (IListenerRegister)ServiceLocator.findService(protocol + "ListenerRegister");
    }

    @Override
    public void registListener() {
        Map registInfoMap = ConfigManager.getSection((String)"notify-regist");
        if (CollectionUtils.isEmpty((Map)registInfoMap)) {
            log.info("no listener is configed.");
            return;
        }
        for (Map.Entry entry : registInfoMap.entrySet()) {
            ListenerProtocol protocol = this.initProtocol((String)entry.getValue());
            if (protocol == null) {
                log.warn("config is empty:" + (String)entry.getKey());
                continue;
            }
            log.info("register Listner:" + protocol);
            String pName = protocol.getProtocol();
            if (StringUtils.isEmpty((String)pName)) {
                log.warn("protocol type is empty.");
                continue;
            }
            String id = protocol.getId();
            if (StringUtils.isEmpty((String)id)) {
                log.warn("listener's id is empty.");
                continue;
            }
            IListenerRegister register = this.createRegister(pName);
            if (register == null) {
                log.warn("the protocol type [" + pName + "] is not supported.");
                continue;
            }
            register.regist(protocol);
        }
    }

    private ListenerProtocol initProtocol(String protocolStr) {
        if (StringUtils.isEmpty((String)protocolStr)) {
            return null;
        }
        if (protocolStr.contains("://")) {
            ListenerProtocol protocol = new ListenerProtocol();
            boolean protocolStart = true;
            boolean urlStart = false;
            boolean paramStart = false;
            StringBuilder sb = new StringBuilder(protocolStr.length());
            String lastKey = "";
            for (int i = 0; i < protocolStr.length(); ++i) {
                String value;
                char ch = protocolStr.charAt(i);
                sb.append(ch);
                if (protocolStart && ':' == ch) {
                    protocolStart = false;
                    String pName = sb.deleteCharAt(sb.length() - 1).toString();
                    protocol.setProtocol(pName);
                    i += 2;
                    urlStart = true;
                    sb.delete(0, sb.length());
                    continue;
                }
                if (urlStart && '?' == ch) {
                    urlStart = false;
                    String url = sb.deleteCharAt(sb.length() - 1).toString();
                    protocol.setUrl(url);
                    paramStart = true;
                    sb.delete(0, sb.length());
                    continue;
                }
                if (paramStart && '=' == ch) {
                    lastKey = sb.deleteCharAt(sb.length() - 1).toString();
                    sb.delete(0, sb.length());
                    continue;
                }
                if (paramStart && '&' == ch) {
                    value = sb.deleteCharAt(sb.length() - 1).toString();
                    this.fillProtocolParams(protocol, lastKey, value);
                    sb.delete(0, sb.length());
                    continue;
                }
                if (!paramStart || i != protocolStr.length() - 1) continue;
                value = sb.toString();
                this.fillProtocolParams(protocol, lastKey, value);
            }
            return protocol;
        }
        log.warn("the notify regist string is wrong. Must contain subString '://'.protocol:" + protocolStr);
        return null;
    }

    private void fillProtocolParams(ListenerProtocol protocol, String lastKey, String value) {
        if ("id".equals(lastKey)) {
            protocol.setId(value);
        } else if ("event".equals(lastKey)) {
            if (!StringUtils.isEmpty((String)value)) {
                List eventList = CollectionUtils.toList((String)value);
                protocol.setEvents(eventList);
            }
        } else {
            protocol.addParam(lastKey, value);
        }
    }
}

