/*
 * Decompiled with CFR 0.152.
 */
package com.hikvision.swdf.monitor.mbean.cache;

import com.hikvision.cms.cache.core.common.CacheConstants;
import com.hikvision.cms.cache.manager.DataLoadException;
import com.hikvision.cms.cache.manager.DataManager;
import com.hikvision.swdf.monitor.mbean.cache.ICacheMBean;

public class CacheMBean
implements ICacheMBean {
    private DataManager dataManager;

    @Override
    public String getCacheType() {
        if (this.dataManager == null) {
            return "";
        }
        return this.dataManager.isThirdStore() ? "thirdpart" : "memory";
    }

    @Override
    public String getTempCacheValue(String key) throws DataLoadException {
        if (this.dataManager == null) {
            return "datamanager is null";
        }
        return this.dataManager.get(key);
    }

    @Override
    public String getSessionCacheValue(String key) throws DataLoadException {
        if (this.dataManager == null) {
            return "datamanager is null";
        }
        return this.dataManager.get(key, CacheConstants.DATA_TYPE.SESSION);
    }

    @Override
    public String getCacheValue(String key, String type) throws DataLoadException {
        if (this.dataManager == null) {
            return "datamanager is null";
        }
        return this.dataManager.get(key, type.equals("session") ? CacheConstants.DATA_TYPE.SESSION : CacheConstants.DATA_TYPE.TEMP);
    }

    @Override
    public String getCacheValue(String key, boolean single) throws DataLoadException {
        if (this.dataManager == null) {
            return "datamanager is null";
        }
        return this.dataManager.get(key, single);
    }

    @Override
    public String getCacheValue(String key, String type, boolean single) throws DataLoadException {
        if (this.dataManager == null) {
            return "datamanager is null";
        }
        return this.dataManager.get(key, type.equals("session") ? CacheConstants.DATA_TYPE.SESSION : CacheConstants.DATA_TYPE.TEMP, single);
    }

    @Override
    public void setSessionValue(String key, String value) throws DataLoadException {
        this.dataManager.set(key, value, CacheConstants.DATA_TYPE.SESSION);
    }

    @Override
    public void setTempValue(String key, String value) throws DataLoadException {
        this.dataManager.set(key, value);
    }

    @Override
    public void setDataManager(DataManager dataManager) {
        this.dataManager = dataManager;
    }
}

