/*
 * Decompiled with CFR 0.152.
 */
package com.hikvision.swdf.monitor.mbean.executor;

import com.hikvision.swdf.core.executor.ThreadExecutorService;
import com.hikvision.swdf.monitor.mbean.executor.ISwdfCoreThreadPoolMBean;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class SwdfCoreThreadPoolMBean
extends ThreadExecutorService
implements ISwdfCoreThreadPoolMBean {
    private static SwdfCoreThreadPoolMBean instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ISwdfCoreThreadPoolMBean getInstance() {
        if (instance != null) return instance;
        Class<SwdfCoreThreadPoolMBean> clazz = SwdfCoreThreadPoolMBean.class;
        synchronized (SwdfCoreThreadPoolMBean.class) {
            instance = new SwdfCoreThreadPoolMBean();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    protected ThreadPoolExecutor getThreadPoolExecutor() {
        if (ThreadExecutorService.executor == null) {
            return null;
        }
        if (ThreadExecutorService.executor instanceof ThreadPoolExecutor) {
            return (ThreadPoolExecutor)ThreadExecutorService.executor;
        }
        return null;
    }

    @Override
    public int getActiveCount() {
        if (this.getThreadPoolExecutor() == null) {
            return 0;
        }
        return this.getThreadPoolExecutor().getActiveCount();
    }

    @Override
    public int getCorePoolSize() {
        if (this.getThreadPoolExecutor() == null) {
            return 0;
        }
        return this.getThreadPoolExecutor().getCorePoolSize();
    }

    @Override
    public int getLargestPoolSize() {
        if (this.getThreadPoolExecutor() == null) {
            return 0;
        }
        return this.getThreadPoolExecutor().getLargestPoolSize();
    }

    @Override
    public int getMaximumPoolSize() {
        if (this.getThreadPoolExecutor() == null) {
            return 0;
        }
        return this.getThreadPoolExecutor().getMaximumPoolSize();
    }

    @Override
    public int getPoolSize() {
        if (this.getThreadPoolExecutor() == null) {
            return 0;
        }
        return this.getThreadPoolExecutor().getPoolSize();
    }

    @Override
    public long getKeepAliveTime() {
        if (this.getThreadPoolExecutor() == null) {
            return 0L;
        }
        return this.getThreadPoolExecutor().getKeepAliveTime(TimeUnit.MILLISECONDS);
    }

    @Override
    public long getTaskCount() {
        if (this.getThreadPoolExecutor() == null) {
            return 0L;
        }
        return this.getThreadPoolExecutor().getTaskCount();
    }

    @Override
    public long getCompletedTaskCount() {
        if (this.getThreadPoolExecutor() == null) {
            return 0L;
        }
        return this.getThreadPoolExecutor().getCompletedTaskCount();
    }

    @Override
    public long getWaittingThreadCount() {
        if (this.getThreadPoolExecutor() == null) {
            return 0L;
        }
        BlockingQueue<Runnable> queue = this.getThreadPoolExecutor().getQueue();
        if (queue == null) {
            return 0L;
        }
        return queue.size();
    }

    @Override
    public void setCorePoolSize(int corePoolSize) {
        if (this.getThreadPoolExecutor() == null) {
            return;
        }
        this.getThreadPoolExecutor().setCorePoolSize(corePoolSize);
    }

    @Override
    public void setMaximumPoolSize(int maximumPoolSize) {
        if (this.getThreadPoolExecutor() == null) {
            return;
        }
        this.getThreadPoolExecutor().setMaximumPoolSize(maximumPoolSize);
    }

    @Override
    public void setKeepAliveTime(long time) {
        if (this.getThreadPoolExecutor() == null) {
            return;
        }
        this.getThreadPoolExecutor().setKeepAliveTime(time, TimeUnit.MILLISECONDS);
    }
}

