/*
 * Decompiled with CFR 0.152.
 */
package com.hikvision.swdf.monitor.mbean.lock.db;

import com.hikvision.swdf.core.lock.ExpireTimeDispose;
import com.hikvision.swdf.core.lock.IExpireTimeDispose;
import com.hikvision.swdf.core.lock.ILock;
import com.hikvision.swdf.core.lock.LockException;
import com.hikvision.swdf.core.lock.Locks;
import com.hikvision.swdf.core.lock.db.DBLockBuilder;
import com.hikvision.swdf.monitor.mbean.lock.LockMBean;
import com.hikvision.swdf.monitor.mbean.lock.db.IDBLockMBean;
import com.ivms6.core.util.CollectionUtils;
import com.ivms6.core.util.StringUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DBLockMBean
extends LockMBean
implements IDBLockMBean {
    DBLockBuilder lockBuilder;

    public DBLockMBean(DBLockBuilder lockBuilder) {
        this.lockBuilder = lockBuilder;
    }

    @Override
    public String getLockMode() {
        return "db";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean targetHasLocked(String target) throws LockException {
        ILock lock = null;
        try {
            lock = this.lockBuilder.tryLock(target, 1);
        }
        catch (LockException e) {
            boolean bl;
            try {
                bl = true;
            }
            catch (Throwable throwable) {
                Locks.unLock(lock);
                throw throwable;
            }
            Locks.unLock(lock);
            return bl;
        }
        Locks.unLock(lock);
        return false;
    }

    @Override
    public boolean getIsExpireTimeDisposeStart() {
        ExpireTimeDispose dispose = this.getDispose();
        if (dispose == null) {
            return false;
        }
        return dispose.isOnStart();
    }

    @Override
    public Long getMinExpireDispose() {
        ExpireTimeDispose dispose = this.getDispose();
        if (dispose == null) {
            return 0L;
        }
        long nanoTime = System.nanoTime() / 1000000L;
        return dispose.getMinExpire() - nanoTime;
    }

    private ExpireTimeDispose getDispose() {
        IExpireTimeDispose dispose = this.lockBuilder.getExpireTimeDispose();
        if (!(dispose instanceof ExpireTimeDispose)) {
            return null;
        }
        return (ExpireTimeDispose)dispose;
    }

    @Override
    public void releaseLock(String target) throws LockException {
        if (StringUtils.isBlank((String)target)) {
            return;
        }
        ExpireTimeDispose dispose = this.getDispose();
        if (dispose == null) {
            return;
        }
        Map<ILock, Long> lockMap = dispose.getLockMap();
        for (ILock lock : lockMap.keySet()) {
            if (!target.equals(lock.getTarget())) continue;
            lock.unLock();
            break;
        }
    }

    @Override
    public Map<String, String> getCurrentProcessLockInfoAndExpireTimes() {
        ExpireTimeDispose dispose = this.getDispose();
        if (dispose == null) {
            return Collections.EMPTY_MAP;
        }
        Map<ILock, Long> lockMap = dispose.getLockMap();
        if (CollectionUtils.isEmpty(lockMap)) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        long nanoTime = System.nanoTime() / 1000000L;
        for (Map.Entry<ILock, Long> entry : lockMap.entrySet()) {
            map.put(entry.getKey().getTarget(), entry.getValue() - nanoTime + "s");
        }
        return map;
    }
}

