/*
 * Decompiled with CFR 0.152.
 */
package com.hikvision.swdf.monitor.mbean.task;

import com.hikvision.swdf.monitor.mbean.task.TaskInfoMBean;
import com.ivms6.core.scheduler.TaskContext;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import org.apache.commons.io.IOUtils;

public class TaskInfo
implements TaskInfoMBean {
    private TaskContext context;

    public TaskInfo(TaskContext context) {
        this.context = context;
    }

    @Override
    public String getTaskId() {
        return this.context.getId();
    }

    @Override
    public String getTaskClassName() {
        return this.context.getTaskEntity().getClass().getName();
    }

    @Override
    public boolean isRunning() {
        return this.context.isRuning();
    }

    @Override
    public Date getReferenceTimeInMillis() {
        long time = this.context.getReferenceTimeInMillis();
        if (time == 0L) {
            return null;
        }
        return new Date(time);
    }

    @Override
    public int getExecuteTimes() {
        return this.context.getExecuteTimes();
    }

    @Override
    public Date getLastFireTime() {
        long time = this.context.getLastFireTime();
        if (time == 0L) {
            return null;
        }
        return new Date(time);
    }

    @Override
    public long getLastPeriod() {
        return this.context.getLastPeriod();
    }

    @Override
    public boolean isLastSuccess() {
        return this.context.isLastSuccess();
    }

    @Override
    public String getSchedulingPattern() {
        return this.context.getTaskEntity().getSchedulingPattern();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getLastExceptionInfo() {
        Throwable ex = this.context.getLastException();
        if (ex == null) {
            return "";
        }
        StringWriter w = new StringWriter();
        PrintWriter pw = new PrintWriter(w);
        try {
            ex.printStackTrace(pw);
            String string = w.toString();
            return string;
        }
        finally {
            IOUtils.closeQuietly((Writer)pw);
        }
    }

    @Override
    public void setSchedulingPattern(String schedulingPattern) {
        this.context.setSchedulingPattern(schedulingPattern);
    }
}

