/*
 * Decompiled with CFR 0.152.
 */
package com.hikvision.swdf.util;

import com.hikvision.swdf.exception.IllegalArgumentException;
import java.sql.SQLException;
import java.util.List;

public class DBExceptionUtils {
    public static void unique(RuntimeException e, String uniqueIndexName, String errorCode, Object[] args) {
        DBExceptionUtils.parseException(e, uniqueIndexName, errorCode, args);
        throw e;
    }

    public static void unique(RuntimeException e, List<String> uniqueIndexNames, List<String> errorCodes, List<Object[]> args) {
        int i = 0;
        while (i < uniqueIndexNames.size()) {
            DBExceptionUtils.parseException(e, uniqueIndexNames.get(i), errorCodes.get(i), args.get(i));
            ++i;
        }
        throw e;
    }

    private static void parseException(Exception e, String uniqueIndexName, String errorCode, Object[] args) {
        Throwable t;
        if (e instanceof SQLException) {
            if (DBExceptionUtils.isUnique("Duplicate entry", e.getMessage(), uniqueIndexName)) {
                throw new IllegalArgumentException(errorCode, "", args);
            }
            if (DBExceptionUtils.isUnique("UNIQUE KEY", e.getMessage(), uniqueIndexName)) {
                throw new IllegalArgumentException(errorCode, "", args);
            }
            if (((SQLException)e).getNextException() != null && DBExceptionUtils.isUnique1(((SQLException)e).getNextException().getMessage(), uniqueIndexName)) {
                throw new IllegalArgumentException(errorCode, "", args);
            }
        }
        if ((t = e.getCause()) != null && t instanceof Exception) {
            Exception ex = (Exception)t;
            DBExceptionUtils.parseException(ex, uniqueIndexName, errorCode, args);
        }
    }

    private static boolean isUnique1(String msg, String uniqueIndexName) {
        return msg.contains(uniqueIndexName) || msg.contains(uniqueIndexName.toLowerCase()) || msg.contains(uniqueIndexName.toUpperCase());
    }

    private static boolean isUnique(String errMsgPre, String msg, String uniqueIndexName) {
        return msg.contains(errMsgPre) && (msg.contains(uniqueIndexName) || msg.contains(uniqueIndexName.toLowerCase()) || msg.contains(uniqueIndexName.toUpperCase()));
    }
}

