/*
 * Decompiled with CFR 0.152.
 */
package com.hikvision.swdf.util;

import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.net.ntp.NTPUDPClient;
import org.apache.commons.net.ntp.NtpV3Packet;
import org.apache.commons.net.ntp.TimeInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimingUtil {
    private static final Logger log = LoggerFactory.getLogger(TimingUtil.class);

    public static boolean timing(Date timingDate) {
        String winDateFormat = "yyyy-MM-dd";
        String winTimeFormat = "HH:mm:ss.SSS";
        String linuxDateFormat = "yyyyMMdd";
        String linuxTimeFormat = "HH:mm:ss.SSS";
        SimpleDateFormat winDf = new SimpleDateFormat(winDateFormat);
        SimpleDateFormat linuxDf = new SimpleDateFormat(linuxDateFormat);
        SimpleDateFormat winTf = new SimpleDateFormat(winTimeFormat);
        SimpleDateFormat linuxTf = new SimpleDateFormat(linuxTimeFormat);
        String winDateString = winDf.format(timingDate);
        String linuxDateString = linuxDf.format(timingDate);
        String winTimeString = winTf.format(timingDate);
        winTimeString = winTimeString.substring(0, winTimeString.length() - 1);
        String linuxTimeString = linuxTf.format(timingDate);
        log.debug("cms timing : " + winDateString + " " + winTimeString);
        String osName = System.getProperty("os.name");
        String cmd = "";
        try {
            if (osName.matches("^(?i)Windows.*$")) {
                cmd = " cmd /c date " + winDateString;
                Runtime.getRuntime().exec(cmd);
                cmd = "  cmd /c time " + winTimeString;
                Runtime.getRuntime().exec(cmd);
            } else {
                String dateCmd = "/bin/date -s '" + linuxDateString + " " + linuxTimeString + "' &&hwclock --systohc";
                String[] comands = new String[]{"/bin/sh", "-c", dateCmd};
                Runtime.getRuntime().exec(comands);
            }
            return true;
        }
        catch (IOException e) {
            log.error("NtpClient timing IOException");
            return false;
        }
    }

    public static boolean getNtpTime(String ntpServer, int ntpPort) {
        try {
            long localOffset = TimingUtil.getLocalOffset(ntpServer, ntpPort);
            Date date = new Date(System.currentTimeMillis() + localOffset);
            return TimingUtil.timing(date);
        }
        catch (Exception e) {
            log.error("getNtpTime Exception:", (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getLocalOffset(String ntpServer, int ntpPort) {
        NTPUDPClient client = new NTPUDPClient();
        client.setDefaultTimeout(10000);
        try {
            client.open();
            InetAddress hostAddr = InetAddress.getByName(ntpServer);
            TimeInfo info = client.getTime(hostAddr, ntpPort);
            NtpV3Packet message = info.getMessage();
            long t4 = System.currentTimeMillis();
            long t1 = message.getOriginateTimeStamp().getTime();
            long t2 = message.getReceiveTimeStamp().getTime();
            long t3 = message.getTransmitTimeStamp().getTime();
            long datagramDelay = t4 - t1 - (t3 - t2);
            long timeOffset = (t2 - t1 + (t3 - t4)) / 2L;
            long l = datagramDelay + timeOffset;
            return l;
        }
        catch (SocketException e) {
            log.error("NtpClient getNtpTime SocketException");
        }
        catch (UnknownHostException e) {
            log.error("NtpClient getNtpTime UnknownHostException");
        }
        catch (IOException e) {
            log.error("NtpClient getNtpTime IOException");
        }
        finally {
            client.close();
        }
        return 0L;
    }
}

