/*
 * Decompiled with CFR 0.152.
 */
package com.hikvision.swdf.util;

import com.hikvision.swdf.annotation.DataType;
import com.hikvision.swdf.annotation.FieldMapping;
import com.ivms6.core.util.DateFormatUtils;
import com.ivms6.core.util.StringUtils;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.List;

public class XmlRequestBeanUtil {
    public static final String XML_DOC_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>";
    public static final String XML_TABLE_START = "<table>";
    public static final String XML_TABLE_END = "</table>";
    public static final String XML_HEAD_START = "<head>";
    public static final String XML_HEAD_END = "</head>";
    public static final String XML_RESULT_START = "<result";
    public static final String XML_ROWS_START = "<rows>";
    public static final String XML_ROWS_END = "</rows>";
    public static final String XML_ROW_START = "<row ";
    public static final String XML_END = " />";

    public static <T> String convertToXml(String xmlType, List<T> list) {
        int size = 1;
        if (list != null) {
            size = list.size() + 1;
        }
        StringBuilder sb = new StringBuilder(size * 100);
        sb.append(XML_DOC_HEADER);
        sb.append(XML_TABLE_START);
        sb.append("\n");
        sb.append(XML_HEAD_START).append("\n");
        sb.append(XML_RESULT_START);
        if (StringUtils.isNotBlank((String)xmlType)) {
            sb.append(" type=\"" + xmlType + "\"");
        }
        if (list != null) {
            sb.append(" result_code=\"0\" message=\"\" size=\"" + list.size() + "\"");
        }
        sb.append(XML_END).append("\n");
        sb.append(XML_HEAD_END).append("\n");
        sb.append(XML_ROWS_START).append("\n");
        if (list != null && list.size() > 0) {
            StringBuffer rowsSb = new StringBuffer("");
            for (int i = 0; i < list.size(); ++i) {
                String rowXml = XmlRequestBeanUtil.objToRowXml(list.get(i));
                rowsSb.append(rowXml);
                rowsSb.append("\n");
            }
            sb.append(rowsSb);
        }
        sb.append(XML_ROWS_END).append("\n");
        sb.append(XML_TABLE_END);
        return sb.toString();
    }

    private static String objToRowXml(Object dto) {
        StringBuilder xmlBuilder = new StringBuilder();
        xmlBuilder.append(XML_ROW_START);
        PropertyDescriptor[] props = null;
        try {
            props = Introspector.getBeanInfo(dto.getClass(), Object.class).getPropertyDescriptors();
        }
        catch (IntrospectionException e) {
            // empty catch block
        }
        if (props != null) {
            for (int i = 0; i < props.length; ++i) {
                String name = props[i].getName();
                String value = null;
                String type = "c";
                try {
                    PropertyDescriptor pd;
                    String pName;
                    Method m = props[i].getReadMethod();
                    if (m == null) continue;
                    Object obj = m.invoke(dto, new Object[0]);
                    FieldMapping annotation = m.getAnnotation(FieldMapping.class);
                    if (annotation == null) continue;
                    if (annotation != null && !StringUtils.isEmpty((String)annotation.value())) {
                        name = annotation.value();
                    }
                    if (annotation != null) {
                        if (annotation.type() == DataType.IGNORE) continue;
                        type = annotation.type().getValue();
                    }
                    value = obj != null ? (StringUtils.isEmpty((String)(pName = annotation.valueField())) ? XmlRequestBeanUtil.convertObjToStr(obj) : ((obj = (pd = new PropertyDescriptor(pName, obj.getClass())).getReadMethod().invoke(obj, new Object[0])) == null ? "null" : XmlRequestBeanUtil.convertObjToStr(obj))) : "null";
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                catch (IntrospectionException e) {
                    e.printStackTrace();
                }
                if (!StringUtils.isNotBlank((String)name)) continue;
                xmlBuilder.append(name);
                xmlBuilder.append("=\"");
                xmlBuilder.append(XmlRequestBeanUtil.toXml(value));
                xmlBuilder.append("\" ");
            }
        }
        xmlBuilder.append(XML_END);
        return xmlBuilder.toString();
    }

    public static String convertObjToStr(Object obj) {
        if (obj instanceof Date) {
            return DateFormatUtils.format((Date)((Date)obj), (String)"yyyy-MM-dd HH:mm:ss");
        }
        if (obj instanceof Boolean) {
            return String.valueOf((Boolean)obj != false ? 1 : 0);
        }
        return String.valueOf(obj);
    }

    public static String toXml(String str) {
        char[] cs = str.toCharArray();
        StringBuilder sb = new StringBuilder(str.length() * 4);
        block7: for (char c : cs) {
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                case '\'': {
                    sb.append("&apos;");
                    continue block7;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        if (sb.length() == str.length()) {
            return str;
        }
        return sb.toString();
    }
}

