/*
 * Decompiled with CFR 0.152.
 */
package com.hikvision.swdf.util.errorcode;

import com.hikvision.swdf.core.log.LogLevelType;
import com.ivms6.core.util.StringUtils;

public class ErrorCode {
    private String id;
    private String code;
    private String name;
    private ErrorCodeType errorCodeType;
    private Boolean isbatch = false;
    private ErrorCode parentCode;
    private LogLevelType logLevelType;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCode() {
        return this.code;
    }

    public String getAllCode() {
        if (this.errorCodeType == ErrorCodeType.GLOBAL) {
            return String.valueOf(this.parseInt(this.code));
        }
        return this.generatorHikErrorCode();
    }

    public String findBussiness() {
        if (this.getErrorCodeType() == ErrorCodeType.GLOBAL) {
            return "0";
        }
        if (this.getErrorCodeType() == ErrorCodeType.BUSINESS) {
            return this.parseInt(this.code).toString();
        }
        ErrorCode parent = this.getParentCode();
        if (parent == null) {
            return "0";
        }
        return parent.findBussiness();
    }

    public String findModule() {
        if (this.getErrorCodeType() == ErrorCodeType.GLOBAL) {
            return "0";
        }
        if (this.getErrorCodeType() == ErrorCodeType.MODULE) {
            return this.parseInt(this.code).toString();
        }
        ErrorCode parent = this.getParentCode();
        if (parent == null) {
            return "0";
        }
        return parent.findModule();
    }

    private Integer parseInt(String value) {
        if (!StringUtils.isEmpty((String)value) && StringUtils.isNumeric((String)value)) {
            return Integer.parseInt(value);
        }
        return 0;
    }

    public String generatorHikErrorCode() {
        String business = this.findBussiness();
        String module = this.findModule();
        Integer businessCode = this.parseInt(business);
        Integer moduleCode = this.parseInt(module);
        Integer errorCode = this.parseInt(this.code);
        if (businessCode > 255 || businessCode < 0) {
            businessCode = 0;
        }
        if (moduleCode > 255 || moduleCode < 0) {
            moduleCode = 0;
        }
        if (errorCode > 65535 || errorCode < 0) {
            errorCode = 0;
        }
        String result = StringUtils.leftPad((String)String.valueOf(moduleCode), (int)3, (String)"0") + StringUtils.leftPad((String)String.valueOf(businessCode), (int)3, (String)"0") + StringUtils.leftPad((String)String.valueOf(errorCode), (int)5, (String)"0");
        return result;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Boolean getIsbatch() {
        if (this.isbatch != null) {
            return this.isbatch;
        }
        if (this.parentCode != null) {
            return this.parentCode.getIsbatch();
        }
        return false;
    }

    public void setIsbatch(Boolean isbatch) {
        this.isbatch = isbatch;
    }

    public ErrorCode getParentCode() {
        return this.parentCode;
    }

    public void setParentCode(ErrorCode parentCode) {
        this.parentCode = parentCode;
    }

    public ErrorCodeType getErrorCodeType() {
        return this.errorCodeType;
    }

    public void setErrorCodeType(ErrorCodeType errorCodeType) {
        this.errorCodeType = errorCodeType;
    }

    public boolean isLogLevelTypeIsIgnore() {
        if (this.logLevelType != null) {
            return this.logLevelType.equals((Object)LogLevelType.IGNORE);
        }
        if (this.parentCode != null) {
            return this.parentCode.isLogLevelTypeIsIgnore();
        }
        return false;
    }

    public LogLevelType getLogLevelType() {
        return this.logLevelType;
    }

    public void setLogLevelType(LogLevelType logLevelType) {
        this.logLevelType = logLevelType;
    }

    public static enum ErrorCodeType {
        GLOBAL,
        BUSINESS,
        MODULE,
        METHOD;

    }
}

