/*
 * Decompiled with CFR 0.152.
 */
package com.hikvision.swdf.util.errorcode;

import com.hikvision.swdf.core.log.LogLevelType;
import com.hikvision.swdf.util.errorcode.ErrorCode;
import com.ivms6.core.util.ClassLoaderUtil;
import com.ivms6.core.util.CollectionUtils;
import com.ivms6.core.util.IOUtils;
import com.ivms6.core.util.StringUtils;
import com.ivms6.core.util.XMLUtils;
import com.ivms6.core.util.cm.ConfigManager;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.BooleanUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorCodeUtil {
    private static Logger log = LoggerFactory.getLogger(ErrorCodeUtil.class);
    private static String errorCodeFilePath = null;
    private static Document doc = null;

    private static String getErrorCodeFilePath() {
        if (!StringUtils.isEmpty((String)errorCodeFilePath)) {
            return errorCodeFilePath;
        }
        errorCodeFilePath = ConfigManager.getConfiguration((String)"system-constant", (String)"errorcode.path");
        if (StringUtils.isEmpty((String)errorCodeFilePath)) {
            errorCodeFilePath = "errorcode/errorcode.xml";
        }
        return errorCodeFilePath;
    }

    public static void clearCache() {
        doc = null;
        errorCodeFilePath = null;
    }

    public static Document getErrorCodeConfig() {
        InputStream in = null;
        if (doc == null) {
            String path = ErrorCodeUtil.getErrorCodeFilePath();
            try {
                try {
                    in = ClassLoaderUtil.getStream((String)path);
                    if (in != null) {
                        doc = XMLUtils.getXmlDocment((InputStream)in);
                    }
                }
                catch (Exception e) {
                    log.warn("find file \"" + path + "\" error.", (Throwable)e);
                    IOUtils.closeQuietly((InputStream)in);
                }
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
            }
        }
        return doc;
    }

    public static ErrorCode getErrorCode(String className, String method) {
        ErrorCode errorCode = null;
        Document document = ErrorCodeUtil.getErrorCodeConfig();
        if (document != null) {
            Element methodNode = (Element)document.selectSingleNode("/log/business[@id='" + className + "']/module/method[@id='" + method + "']");
            if (methodNode != null) {
                String batch;
                errorCode = new ErrorCode();
                errorCode.setId(method);
                errorCode.setName(methodNode.attributeValue("name"));
                errorCode.setCode(methodNode.attributeValue("code"));
                errorCode.setErrorCodeType(ErrorCode.ErrorCodeType.METHOD);
                String logLevel = methodNode.attributeValue("logLevel");
                if (!StringUtils.isEmpty((String)logLevel)) {
                    errorCode.setLogLevelType(LogLevelType.valueOf(StringUtils.defaultIfBlank((String)logLevel, (String)"DEBUG").toUpperCase()));
                }
                if (StringUtils.isNotBlank((String)(batch = methodNode.attributeValue("isbatch")))) {
                    errorCode.setIsbatch(BooleanUtils.toBoolean((String)batch));
                }
                Element moduleNode = methodNode.getParent();
                ErrorCode moduleCode = null;
                moduleCode = new ErrorCode();
                moduleCode.setName(moduleNode.attributeValue("name"));
                moduleCode.setCode(moduleNode.attributeValue("code"));
                moduleCode.setErrorCodeType(ErrorCode.ErrorCodeType.MODULE);
                errorCode.setParentCode(moduleCode);
                Element businessNode = moduleNode.getParent();
                ErrorCode businessCode = new ErrorCode();
                businessCode.setId(className);
                businessCode.setName(businessNode.attributeValue("name"));
                businessCode.setCode(businessNode.attributeValue("code"));
                businessCode.setLogLevelType(LogLevelType.valueOf(StringUtils.defaultIfBlank((String)businessNode.attributeValue("logLevel"), (String)"DEBUG").toUpperCase()));
                businessCode.setIsbatch(BooleanUtils.toBoolean((String)StringUtils.defaultIfBlank((String)businessNode.attributeValue("isbatch"), (String)"true")));
                businessCode.setErrorCodeType(ErrorCode.ErrorCodeType.BUSINESS);
                if (errorCode.getLogLevelType() == null) {
                    errorCode.setLogLevelType(businessCode.getLogLevelType());
                }
                moduleCode.setParentCode(businessCode);
            } else {
                Element businessNode = (Element)document.selectSingleNode("/log/business[@id='" + className + "']");
                if (businessNode != null) {
                    errorCode = new ErrorCode();
                    errorCode.setId(className);
                    errorCode.setName(businessNode.attributeValue("name"));
                    errorCode.setCode(businessNode.attributeValue("code"));
                    errorCode.setLogLevelType(LogLevelType.valueOf(StringUtils.defaultIfBlank((String)businessNode.attributeValue("logLevel"), (String)"DEBUG").toUpperCase()));
                    errorCode.setIsbatch(BooleanUtils.toBoolean((String)StringUtils.defaultIfBlank((String)businessNode.attributeValue("isbatch"), (String)"true")));
                    errorCode.setErrorCodeType(ErrorCode.ErrorCodeType.BUSINESS);
                }
            }
        }
        return errorCode;
    }

    public static ErrorCode getGlobalErrorCode(String id) {
        Element exceptionNode;
        ErrorCode errorCode = null;
        Document document = ErrorCodeUtil.getErrorCodeConfig();
        if (document != null && (exceptionNode = (Element)document.selectSingleNode("/log/global/*/exception[@id='" + id + "']")) != null) {
            errorCode = new ErrorCode();
            errorCode.setId(id);
            errorCode.setCode(exceptionNode.attributeValue("code"));
            errorCode.setName(exceptionNode.attributeValue("name"));
            errorCode.setErrorCodeType(ErrorCode.ErrorCodeType.GLOBAL);
        }
        if (errorCode == null) {
            errorCode = new ErrorCode();
            errorCode.setId(id);
            errorCode.setCode("-1");
            errorCode.setName("\u672a\u77e5\u9519\u8bef");
            errorCode.setErrorCodeType(ErrorCode.ErrorCodeType.GLOBAL);
        }
        return errorCode;
    }

    public static List<ErrorCode> getBusiness(String name) {
        List businesses;
        ArrayList<ErrorCode> errorCodes = new ArrayList<ErrorCode>();
        Document document = ErrorCodeUtil.getErrorCodeConfig();
        if (document != null && CollectionUtils.isNotEmpty((Collection)(businesses = document.selectNodes("/log/business")))) {
            for (Element e : businesses) {
                String n = e.attributeValue("name");
                if (StringUtils.isBlank((String)n) || !StringUtils.isBlank((String)name) && (!StringUtils.isNotBlank((String)n) || n.indexOf(name) < 0)) continue;
                ErrorCode errorCode = new ErrorCode();
                errorCode.setId(e.attributeValue("id"));
                errorCode.setCode(e.attributeValue("code"));
                errorCode.setName(e.attributeValue("name"));
                errorCodes.add(errorCode);
            }
        }
        return errorCodes;
    }

    public static List<ErrorCode> getAct(String id, String name) {
        ArrayList<ErrorCode> errorCodes = new ArrayList<ErrorCode>();
        Document document = ErrorCodeUtil.getErrorCodeConfig();
        if (document != null) {
            List methods = null;
            if (StringUtils.isNotBlank((String)id)) {
                methods = document.selectNodes("/log/business[@code='" + id + "']/*/method");
            }
            if (CollectionUtils.isNotEmpty(methods)) {
                for (Element e : methods) {
                    String n = e.attributeValue("name");
                    if (StringUtils.isBlank((String)n) || StringUtils.equals((String)LogLevelType.IGNORE.name(), (String)e.attributeValue("logLevel"))) continue;
                    if (StringUtils.isBlank((String)e.attributeValue("logLevel"))) {
                        Element p = e.getParent().getParent();
                        if (p == null || StringUtils.equals((String)LogLevelType.IGNORE.name(), (String)p.attributeValue("logLevel")) || !StringUtils.isBlank((String)name) && (!StringUtils.isNotBlank((String)n) || n.indexOf(name) < 0)) continue;
                        ErrorCode errorCode = new ErrorCode();
                        errorCode.setId(e.attributeValue("id"));
                        errorCode.setCode(e.attributeValue("code"));
                        errorCode.setName(e.attributeValue("name"));
                        errorCodes.add(errorCode);
                        continue;
                    }
                    if (!StringUtils.isBlank((String)name) && (!StringUtils.isNotBlank((String)n) || n.indexOf(name) < 0)) continue;
                    ErrorCode errorCode = new ErrorCode();
                    errorCode.setId(e.attributeValue("id"));
                    errorCode.setCode(e.attributeValue("code"));
                    errorCode.setName(e.attributeValue("name"));
                    errorCodes.add(errorCode);
                }
            }
        }
        return errorCodes;
    }
}

