/*
 * Decompiled with CFR 0.152.
 */
package com.hikvision.swdf.util.network.socket.mina;

import com.hikvision.swdf.util.network.callback.ICallBack;
import com.hikvision.swdf.util.network.socket.mina.MinaNioConnection;
import com.hikvision.swdf.util.network.socket.mina.codec.IvmsCodecFactoryAdapter;
import com.hikvision.swdf.util.network.socket.mina.handler.IvmsIoHandlerAdaper;
import com.ivms6.core.util.CollectionUtils;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.service.IoConnector;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.executor.ExecutorFilter;
import org.apache.mina.transport.socket.SocketSessionConfig;
import org.apache.mina.transport.socket.nio.NioSocketConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinaConnectionManager {
    public static final int MAX_PACKET_LEN = 0x800000;
    public static final int MAX_IDLE_TIME = 30;
    Logger log = LoggerFactory.getLogger(MinaConnectionManager.class);
    private IoConnector connector;
    private IvmsCodecFactoryAdapter codecFacotryAdapter;
    private IvmsIoHandlerAdaper handlerAdaper;
    private Map<String, IoSession> reverseSessionMap = new ConcurrentHashMap<String, IoSession>();
    private long timeout = 60000L;
    private static final MinaConnectionManager instance = new MinaConnectionManager();
    private long lastCleanMoment = 0L;
    private long cleanPeriod = 300000L;

    private MinaConnectionManager() {
    }

    public static MinaConnectionManager getInstance() {
        return instance;
    }

    private synchronized IoConnector getConnector() {
        if (this.connector == null || this.connector.isDisposed()) {
            this.connector = new NioSocketConnector(2);
            this.codecFacotryAdapter = new IvmsCodecFactoryAdapter();
            this.connector.getFilterChain().addLast("codec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)this.codecFacotryAdapter));
            this.connector.getFilterChain().addLast("Executor", (IoFilter)new ExecutorFilter());
            SocketSessionConfig cfg = (SocketSessionConfig)this.connector.getSessionConfig();
            this.handlerAdaper = new IvmsIoHandlerAdaper();
            this.connector.setHandler((IoHandler)this.handlerAdaper);
            cfg.setMinReadBufferSize(1024);
            cfg.setMaxReadBufferSize(65536);
            cfg.setSendBufferSize(131072);
            cfg.setIdleTime(IdleStatus.BOTH_IDLE, 90);
            cfg.setWriteTimeout(90);
            cfg.setUseReadOperation(true);
            cfg.setTcpNoDelay(true);
            cfg.setKeepAlive(true);
            cfg.setReuseAddress(true);
            cfg.setSoLinger(0);
        }
        return this.connector;
    }

    public IoConnector getManager() {
        return this.getConnector();
    }

    public MinaNioConnection getConnection(InetSocketAddress dest) throws IOException {
        ConnectFuture future;
        if (dest == null) {
            return null;
        }
        IoSession session = null;
        String key = dest.getAddress().getHostAddress() + ":" + dest.getPort();
        session = this.reverseSessionMap.get(key);
        if (session == null) {
            future = this.getConnector().connect((SocketAddress)dest);
            future.awaitUninterruptibly(this.timeout);
            session = future.getSession();
        } else if (!session.isConnected()) {
            session.close(true);
            future = this.getConnector().connect((SocketAddress)dest);
            future.awaitUninterruptibly(this.timeout);
            session = future.getSession();
        }
        if (session == null) {
            this.reverseSessionMap.remove(key);
            throw new IOException("can not connect to " + dest.toString());
        }
        this.reverseSessionMap.put(key, session);
        this.checkToClean();
        MinaNioConnection conn = new MinaNioConnection(session);
        return conn;
    }

    public MinaNioConnection createConnection(InetSocketAddress dest, ProtocolCodecFactory codecFactory, IoHandler handler) throws IOException {
        if (dest == null) {
            return null;
        }
        IoSession session = null;
        ConnectFuture future = this.getConnector().connect((SocketAddress)dest);
        future.awaitUninterruptibly(this.timeout);
        session = future.getSession();
        MinaNioConnection conn = new MinaNioConnection(session);
        this.registerConnConfig(conn, codecFactory, handler);
        return conn;
    }

    private void checkToClean() {
        long now = System.currentTimeMillis();
        if (this.lastCleanMoment == 0L) {
            this.lastCleanMoment = now;
        }
        if (now > this.lastCleanMoment + this.cleanPeriod) {
            this.cleanSession();
            this.lastCleanMoment = System.currentTimeMillis();
        }
    }

    public MinaNioConnection getConnection(InetSocketAddress dest, ProtocolCodecFactory codecFactory, IoHandler handler) throws IOException {
        MinaNioConnection conn = this.getConnection(dest);
        if (conn == null) {
            throw new IOException("can not connect to " + dest.toString());
        }
        this.registerConnConfig(conn, codecFactory, handler);
        return conn;
    }

    public void registerConnConfig(MinaNioConnection conn, ProtocolCodecFactory codecFactory, IoHandler handler) {
        if (conn == null || this.getConnector() == null || this.codecFacotryAdapter == null || this.handlerAdaper == null) {
            this.log.error("connector is not inited");
            return;
        }
        try {
            this.codecFacotryAdapter.setDecoder(conn.getId() + "", codecFactory.getDecoder(conn.getSession()));
        }
        catch (Exception e) {
            this.log.error("regist decoder error.", (Throwable)e);
        }
        try {
            this.codecFacotryAdapter.setEncoder(conn.getId() + "", codecFactory.getEncoder(conn.getSession()));
        }
        catch (Exception e) {
            this.log.error("regist encoder error.", (Throwable)e);
        }
        this.handlerAdaper.setHandler(conn.getSession(), handler);
    }

    public void unRegistConnConfig(MinaNioConnection conn) {
        String key = conn.getId() + "";
        this.codecFacotryAdapter.removeDecoder(key);
        this.codecFacotryAdapter.removeEncoder(key);
        this.handlerAdaper.removeHandler(conn.getSession());
    }

    public void close() {
        this.connector.dispose();
    }

    public void cleanSession() {
        if (CollectionUtils.isEmpty(this.reverseSessionMap)) {
            return;
        }
        this.log.info("start to clean session.");
        ArrayList<String> removeKeys = new ArrayList<String>();
        for (Map.Entry<String, IoSession> entry : this.reverseSessionMap.entrySet()) {
            String key = entry.getKey();
            IoSession session = entry.getValue();
            if (!session.isConnected()) {
                removeKeys.add(key);
                session.close(true);
                continue;
            }
            Object callBackAttr = session.getAttribute((Object)"callback");
            if (callBackAttr == null || !(callBackAttr instanceof Map)) continue;
            Map callBackMap = (Map)callBackAttr;
            this.clean0(callBackMap);
        }
        for (String key : removeKeys) {
            this.reverseSessionMap.remove(key);
        }
    }

    private void clean0(Map<String, ICallBack> callBackMap) {
        ArrayList<String> removeKeys = new ArrayList<String>();
        for (Map.Entry<String, ICallBack> entry : callBackMap.entrySet()) {
            long timeout;
            String key = entry.getKey();
            ICallBack callBack = entry.getValue();
            long now = System.currentTimeMillis() - 10000L;
            if (now - (timeout = callBack.getTimeout()) <= callBack.getRegistTime()) continue;
            removeKeys.add(key);
        }
        for (String key : removeKeys) {
            callBackMap.remove(key);
            this.log.info("clean session for key:" + key);
        }
    }
}

