/*
 * Decompiled with CFR 0.152.
 */
package com.hikvision.swdf.util.network.socket.mina;

import com.hikvision.swdf.util.network.IConnection;
import com.hikvision.swdf.util.network.callback.ICallBack;
import com.hikvision.swdf.util.network.exception.WriteException;
import java.net.SocketAddress;
import java.util.Set;
import org.apache.mina.core.future.CloseFuture;
import org.apache.mina.core.session.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinaNioConnection
implements IConnection {
    Logger log = LoggerFactory.getLogger(MinaNioConnection.class);
    private IoSession session;
    private long timeout = 30000L;
    public static final String KEY_CALL_BACK = "callback";

    public MinaNioConnection(IoSession session) {
        this.session = session;
    }

    public IoSession getSession() {
        return this.session;
    }

    @Override
    public void close(boolean immediately) {
        this.log.info("close connection." + this.session.getServiceAddress());
        CloseFuture future = this.session.close(immediately);
        future.awaitUninterruptibly(this.timeout);
        this.session.removeAttribute((Object)KEY_CALL_BACK);
    }

    @Override
    public Object getAttribute(Object key) {
        return this.session.getAttribute(key);
    }

    @Override
    public Object getAttribute(Object key, Object defaultValue) {
        return this.session.getAttribute(key, defaultValue);
    }

    @Override
    public Set<Object> getAttributeKeys() {
        return this.session.getAttributeKeys();
    }

    @Override
    public long getId() {
        return this.session.getId();
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.session.getLocalAddress();
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.session.getRemoteAddress();
    }

    @Override
    public boolean isClosing() {
        return this.session.isClosing();
    }

    @Override
    public boolean isConnected() {
        return this.session.isConnected();
    }

    @Override
    public Object removeAttribute(Object key) {
        return this.session.removeAttribute(key);
    }

    public Object setAttribute(Object key) {
        return this.session.setAttribute(key);
    }

    @Override
    public Object setAttribute(Object key, Object value) {
        return this.session.setAttribute(key, value);
    }

    @Override
    public Object write(Object message) {
        try {
            this.session.write(message);
        }
        catch (Exception e) {
            throw new WriteException("write message to socket error.", e);
        }
        return null;
    }

    @Override
    public void writeNonBlocking(Object message, ICallBack callBack) {
        try {
            this.session.write(message);
        }
        catch (Exception e) {
            throw new WriteException("write message to socket error.", e);
        }
    }
}

