/*
 * Decompiled with CFR 0.152.
 */
package com.hikvision.swdf.util.network.socket.mina.codec;

import com.hikvision.swdf.util.network.socket.mina.codec.IvmsDefaultDecoder;
import com.hikvision.swdf.util.network.socket.mina.codec.IvmsDefaultEncoder;
import com.ivms6.core.util.StringUtils;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolEncoder;

public class IvmsCodecFactoryAdapter
implements ProtocolCodecFactory {
    private Map<String, ProtocolDecoder> decoderPool = new ConcurrentHashMap<String, ProtocolDecoder>();
    private Map<String, ProtocolEncoder> encoderPool = new ConcurrentHashMap<String, ProtocolEncoder>();
    private ProtocolDecoder defaultDecoder;
    private ProtocolEncoder defaultEncoder;

    public IvmsCodecFactoryAdapter() {
        this(Charset.defaultCharset());
    }

    public IvmsCodecFactoryAdapter(Charset charset) {
        this.defaultDecoder = new IvmsDefaultDecoder(charset);
        this.defaultEncoder = new IvmsDefaultEncoder(charset);
    }

    public ProtocolDecoder getDecoder(IoSession session) throws Exception {
        ProtocolDecoder decoder = this.decoderPool.get(session.getId() + "");
        if (decoder == null) {
            return this.defaultDecoder;
        }
        return decoder;
    }

    public ProtocolEncoder getEncoder(IoSession session) throws Exception {
        ProtocolEncoder encoder = this.encoderPool.get(session.getId() + "");
        if (encoder == null) {
            return this.defaultEncoder;
        }
        return encoder;
    }

    public void setEncoder(String key, ProtocolEncoder encoder) {
        if (StringUtils.isEmpty((String)key)) {
            return;
        }
        this.encoderPool.put(key, encoder);
    }

    public void removeEncoder(String key) {
        this.encoderPool.remove(key);
    }

    public void setDecoder(String key, ProtocolDecoder decoder) {
        if (StringUtils.isEmpty((String)key)) {
            return;
        }
        this.decoderPool.put(key, decoder);
    }

    public void removeDecoder(String key) {
        this.decoderPool.remove(key);
    }
}

