/*
 * Decompiled with CFR 0.152.
 */
package com.hikvision.swdf.util.network.socket.mina.handler;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IvmsIoHandlerAdaper
extends IoHandlerAdapter {
    private Map<String, IoHandler> handlerPool = new ConcurrentHashMap<String, IoHandler>();
    Logger log = LoggerFactory.getLogger(IvmsIoHandlerAdaper.class);

    public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
        this.log.debug("exception caught", cause);
        IoHandler handler = this.getHandler(session);
        if (handler == null) {
            this.log.debug("there is no handler is registed for session");
            return;
        }
        handler.exceptionCaught(session, cause);
    }

    public void messageReceived(IoSession session, Object message) throws Exception {
        this.log.debug("message received,msg:" + message.toString());
        IoHandler handler = this.getHandler(session);
        if (handler == null) {
            this.log.debug("there is no handler is registed for session");
            return;
        }
        handler.messageReceived(session, message);
    }

    public void messageSent(IoSession session, Object message) throws Exception {
        this.log.debug("message sent,msg:" + message.toString());
        IoHandler handler = this.getHandler(session);
        if (handler == null) {
            this.log.debug("there is no handler is registed for session");
            return;
        }
        handler.messageSent(session, message);
    }

    public void sessionClosed(IoSession session) throws Exception {
        this.log.debug("session closed" + session.toString());
        IoHandler handler = this.getHandler(session);
        if (handler == null) {
            this.log.debug("there is no handler is registed for session");
            return;
        }
        handler.sessionClosed(session);
        this.removeHandler(session);
    }

    public void sessionCreated(IoSession session) throws Exception {
        this.log.debug("session created" + session.toString());
        IoHandler handler = this.getHandler(session);
        if (handler == null) {
            this.log.debug("there is no handler is registed for session");
            return;
        }
        handler.sessionCreated(session);
    }

    public void sessionIdle(IoSession session, IdleStatus status) throws Exception {
        this.log.debug("session idle" + session.toString());
        IoHandler handler = this.getHandler(session);
        if (handler == null) {
            this.log.debug("there is no handler is registed for session");
            return;
        }
        handler.sessionIdle(session, status);
    }

    public void sessionOpened(IoSession session) throws Exception {
        this.log.debug("session oopended" + session.toString());
        IoHandler handler = this.getHandler(session);
        if (handler == null) {
            this.log.debug("there is no handler is registed for session");
            return;
        }
        handler.sessionOpened(session);
    }

    public IoHandler getHandler(IoSession session) {
        if (session == null) {
            return null;
        }
        return this.handlerPool.get(session.getId() + "");
    }

    public void setHandler(IoSession session, IoHandler handler) {
        if (session == null) {
            return;
        }
        this.handlerPool.put(session.getId() + "", handler);
    }

    public void removeHandler(IoSession session) {
        if (session == null) {
            return;
        }
        this.handlerPool.remove(session.getId() + "");
    }
}

