/*
 * Decompiled with CFR 0.152.
 */
package com.hikvision.swdf.util.tree;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.annotate.JsonIgnore;

public class TreeNode
implements Serializable {
    private static final long serialVersionUID = 7592482157363279522L;
    private String id;
    private String label;
    private Boolean isParent;
    private String cls;
    private String parentId;
    @JsonIgnore
    private TreeNode parentNode;
    private List<TreeNode> children;
    private Map<String, Object> extra;
    private boolean checked;
    private boolean chkDisabled = false;
    private boolean isHidden;
    private boolean open = false;

    public String getId() {
        return this.id;
    }

    public TreeNode() {
    }

    public TreeNode(String id, String parentId, String label) {
        this.id = id;
        this.parentId = parentId;
        this.label = label;
    }

    public TreeNode findTreeNode(String id) {
        if (StringUtils.equals((String)id, (String)this.id)) {
            return this;
        }
        if (this.children != null && !this.children.isEmpty()) {
            for (TreeNode t : this.children) {
                TreeNode t1 = t.findTreeNode(id);
                if (t1 == null) continue;
                return t1;
            }
            return null;
        }
        return null;
    }

    @JsonIgnore
    public int getNodeDepth() {
        if (null == this.parentNode) {
            return 1;
        }
        return 1 + this.parentNode.getNodeDepth();
    }

    @JsonIgnore
    public int getTreeDepth() {
        int depth = 1;
        List<TreeNode> allNode = this.getAll();
        for (TreeNode tn : allNode) {
            int nodeDepth;
            if (null != tn.getChildren() && !tn.getChildren().isEmpty() || depth >= (nodeDepth = tn.getNodeDepth())) continue;
            depth = nodeDepth;
        }
        return depth;
    }

    @JsonIgnore
    public List<TreeNode> getAll() {
        ArrayList<TreeNode> list = new ArrayList<TreeNode>();
        list.add(this);
        if (this.children != null && !this.children.isEmpty()) {
            for (TreeNode t : this.children) {
                list.addAll(t.getAll());
            }
        }
        return list;
    }

    public void setId(String id) {
        if (null != this.children) {
            for (TreeNode tn : this.children) {
                tn.setParentId(id);
            }
        }
        this.id = id;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Boolean getIsParent() {
        return this.isParent;
    }

    public void setIsParent(Boolean isParent) {
        this.isParent = isParent;
    }

    public String getCls() {
        return this.cls;
    }

    public void setCls(String cls) {
        this.cls = cls;
    }

    public List<TreeNode> getChildren() {
        return this.children;
    }

    public void addAllChildren(List<TreeNode> list) {
        if (this.children == null) {
            this.children = new ArrayList<TreeNode>();
        }
        for (TreeNode tn : list) {
            if (null != this.id) {
                tn.setParentId(this.id);
            }
            tn.setParentNode(this);
        }
        this.children.addAll(list);
    }

    public void addChildren(TreeNode treeNode) {
        if (this.children == null) {
            this.children = new ArrayList<TreeNode>();
        }
        if (treeNode == null) {
            return;
        }
        if (null != this.id) {
            treeNode.setParentId(this.id);
        }
        treeNode.setParentNode(this);
        this.children.add(treeNode);
    }

    public void setChildren(List<TreeNode> children) {
        if (null != this.id && children != null) {
            for (TreeNode tn : children) {
                tn.setParentId(this.id);
                tn.setParentNode(this);
            }
        }
        this.children = children;
    }

    public Map<String, Object> getExtra() {
        return this.extra;
    }

    public void setExtra(Map<String, Object> extra) {
        this.extra = extra;
    }

    public void putExtra(String name, Object obj) {
        if (this.extra == null) {
            this.setExtra(new HashMap<String, Object>());
        }
        this.extra.put(name, obj);
    }

    public Object getExtraProperty(String name) {
        if (this.extra == null) {
            return null;
        }
        return this.extra.get(name);
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public TreeNode getParentNode() {
        return this.parentNode;
    }

    public void setParentNode(TreeNode parentNode) {
        this.parentNode = parentNode;
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
    }

    public boolean isChkDisabled() {
        return this.chkDisabled;
    }

    public void setChkDisabled(boolean chkDisabled) {
        this.chkDisabled = chkDisabled;
    }

    public boolean getIsHidden() {
        return this.isHidden;
    }

    public void setIsHidden(boolean isHidden) {
        this.isHidden = isHidden;
    }

    public boolean isOpen() {
        return this.open;
    }

    public void setOpen(boolean open) {
        this.open = open;
    }
}

