/*
 * Decompiled with CFR 0.152.
 */
package com.hikvision.swdf.util.tree;

import com.hikvision.swdf.util.tree.TreeNode;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonSerialize;

public class TreeUtils {
    private static final ObjectMapper mapper = new ObjectMapper();

    public static TreeNode handleChildren(List<TreeNode> list) {
        TreeNode result = null;
        HashMap map = new HashMap();
        for (TreeNode treeNode : list) {
            String parentId = treeNode.getParentId();
            if (parentId == null) {
                result = treeNode;
                continue;
            }
            if (map.containsKey(parentId)) {
                ((List)map.get(parentId)).add(treeNode);
                continue;
            }
            ArrayList<TreeNode> mapList = new ArrayList<TreeNode>();
            mapList.add(treeNode);
            map.put(parentId, mapList);
        }
        for (TreeNode treeNode : list) {
            String id = treeNode.getId();
            if (!map.containsKey(id)) continue;
            treeNode.addAllChildren((List)map.get(id));
        }
        return result;
    }

    public static String toJson(TreeNode node) throws IOException {
        return mapper.writeValueAsString((Object)node);
    }

    public static void toJson(OutputStream out, TreeNode node) throws JsonProcessingException, IOException {
        mapper.writeValue(out, (Object)node);
    }

    public static void toJson(OutputStream out, List<TreeNode> nodeList) throws JsonProcessingException, IOException {
        mapper.writeValue(out, nodeList);
    }

    public static void toJson(Writer writer, TreeNode node) throws JsonProcessingException, IOException {
        mapper.writeValue(writer, (Object)node);
    }

    public static void toJson(Writer writer, List<TreeNode> nodeList) throws JsonProcessingException, IOException {
        mapper.writeValue(writer, nodeList);
    }

    public static TreeNode fromJson(String json) throws JsonParseException, JsonMappingException, IOException {
        return (TreeNode)mapper.readValue(json, TreeNode.class);
    }

    static {
        mapper.setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
    }
}

