/*
 * Decompiled with CFR 0.152.
 */
package com.hikvision.swdf.util.validator;

import com.hikvision.swdf.util.validator.IvmsFieldWatcher;
import com.hikvision.swdf.util.validator.IvmsValidator;
import com.ivms6.core.util.BeanUtils;
import com.ivms6.core.util.StringUtils;
import com.ivms6.core.util.cm.ConfigManager;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IvmsValidatorBuilder {
    private static final String DEFAULT_CONFIG = "config.xml";
    private static final Logger log = LoggerFactory.getLogger(IvmsValidatorBuilder.class);
    private Map<String, Class<?>> classMap = new HashMap();
    private static volatile IvmsValidatorBuilder ivmsValidatorBuilder = null;
    private static final Lock lock = new ReentrantLock();
    private static final String VALIDATOR_CONFIG_SECTION = "validator-config";
    private static final String VALIDATOR_CONFIG_KEY_START = "validator.config";
    private static final int VALIDATOR_CONFIG_KEY_START_LENGTH = "validator.config".length();

    public String getDefaultConfig() {
        return DEFAULT_CONFIG;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IvmsValidatorBuilder getInstance() {
        if (ivmsValidatorBuilder == null) {
            lock.lock();
            try {
                if (ivmsValidatorBuilder == null) {
                    ivmsValidatorBuilder = new IvmsValidatorBuilder();
                }
            }
            finally {
                lock.unlock();
            }
        }
        return ivmsValidatorBuilder;
    }

    private void addClassMapByDefault() {
        SAXReader reader = new SAXReader();
        try {
            Document doc = reader.read(this.getClass().getResource(this.getDefaultConfig()));
            Iterator iterator = doc.getRootElement().elementIterator("validator");
            while (iterator.hasNext()) {
                Element element = (Element)iterator.next();
                String name = element.attributeValue("name");
                String className = element.attributeValue("class");
                try {
                    Class<?> clazz = Class.forName(className);
                    this.classMap.put(name, clazz);
                    log.debug("xml validator config add key:{},class:{}", (Object)name, (Object)className);
                }
                catch (ClassNotFoundException e) {
                    log.warn("config xml ClassNotFoundException\u3002key:{},vlue:{}", (Object)name, (Object)className);
                    log.warn("config xml,error:", (Throwable)e);
                }
            }
        }
        catch (DocumentException e) {
            log.error("config.xml file Error aboutError:" + (Object)((Object)e));
        }
    }

    public String getValidatorConfigSection() {
        return VALIDATOR_CONFIG_SECTION;
    }

    public Map<String, String> getSectionMap() {
        return ConfigManager.getSection((String)this.getValidatorConfigSection());
    }

    private void addClassMapByConfigManager() {
        Map<String, String> map = this.getSectionMap();
        if (map == null) {
            return;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            if (StringUtils.isBlank((String)key) || !StringUtils.startsWith((String)key, (String)VALIDATOR_CONFIG_KEY_START)) continue;
            key = StringUtils.substring((String)key, (int)(VALIDATOR_CONFIG_KEY_START_LENGTH + 1));
            String className = entry.getValue();
            try {
                Class<?> clazz = Class.forName(className);
                this.classMap.put(key, clazz);
                log.debug("validator config add key:{},class:{}", (Object)key, (Object)entry.getValue());
            }
            catch (ClassNotFoundException e) {
                log.warn("config proterities ClassNotFoundException\u3002key:{},vlue:{}", (Object)key, (Object)className);
                log.warn("config proterities,error:", (Throwable)e);
            }
        }
    }

    protected IvmsValidatorBuilder() {
        this.addClassMapByDefault();
        this.addClassMapByConfigManager();
    }

    public static IvmsValidator buildValidator(String vtype, Map<String, Object> params, Map<String, Object> valueMap) {
        return IvmsValidatorBuilder.getInstance().build(vtype, params, valueMap);
    }

    public static IvmsValidator buildValidator(String vtype, Map<String, Object> params) {
        IvmsFieldWatcher ivmsFieldWatcher = null;
        return IvmsValidatorBuilder.getInstance().build(vtype, params, ivmsFieldWatcher);
    }

    public static IvmsValidator buildValidator(String vtype) {
        IvmsFieldWatcher ivmsFieldWatcher = null;
        return IvmsValidatorBuilder.getInstance().build(vtype, null, ivmsFieldWatcher);
    }

    public IvmsValidator build(String vtype, Map<String, Object> params, Map<String, Object> valueMap) {
        PrarmIvmsFieldWatcher ivmsFieldWatcher = new PrarmIvmsFieldWatcher(valueMap);
        return this.build(vtype, params, ivmsFieldWatcher);
    }

    public IvmsValidator build(String vtype, Map<String, Object> params) {
        IvmsFieldWatcher ivmsFieldWatcher = null;
        return this.build(vtype, params, ivmsFieldWatcher);
    }

    public IvmsValidator build(String vtype) {
        IvmsFieldWatcher ivmsFieldWatcher = null;
        return this.build(vtype, null, ivmsFieldWatcher);
    }

    public static IvmsValidator buildValidator(String vtype, Map<String, Object> params, IvmsFieldWatcher ivmsFieldWatcher) {
        return IvmsValidatorBuilder.getInstance().build(vtype, params, ivmsFieldWatcher);
    }

    public IvmsValidator build(String vtype, Map<String, Object> params, IvmsFieldWatcher ivmsFieldWatcher) {
        if (StringUtils.isBlank((String)vtype)) {
            return null;
        }
        Class<?> clazz = this.classMap.get(vtype);
        if (clazz == null) {
            return null;
        }
        try {
            IvmsValidator validator = (IvmsValidator)clazz.newInstance();
            validator.setIvmsFieldWatcher(ivmsFieldWatcher);
            if (params != null) {
                BeanUtils.populate((Object)validator, params);
            }
            return validator;
        }
        catch (Exception e) {
            log.warn("builder to Validator error, aboutError:" + e);
            return null;
        }
    }

    private static class PrarmIvmsFieldWatcher
    implements IvmsFieldWatcher {
        Map<String, Object> valueMap;

        private PrarmIvmsFieldWatcher(Map<String, Object> valueMap) {
            this.valueMap = valueMap;
        }

        @Override
        public Object getFieldValue(String name) {
            return this.valueMap.get(name);
        }
    }
}

